<?php
/**
 * @Packge     : consua
 * @Version    : 1.0
 * @Author     : consua
 * @Author URI : https://themeforest.net/user/validthemes/portfolio
 * Template Name: Coming Soon Page
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) ) {
        $consuacoming_soontitle     = consua_opt( 'consua_coming_soon_title' );
        $consuacoming_soonsubtitle  = consua_opt( 'consua_coming_soon_subtitle' );
        $consuacoming_soonbtntext   = consua_opt( 'consua_coming_soon_btn_text' );
    } else {
        $consuacoming_soontitle     = __( 'Website Under Construction', 'consua' );
        $consuacoming_soonsubtitle  = __( 'Website Under Construction. Work Is Going On For The Website Please Stay With Us.', 'consua' );
        $consuacoming_soonbtntext   = __( 'Return To Home', 'consua' );
    }


    // get header
    get_header();

    echo '<section class="vs-error-wrapper space">';
        echo '<div class="container">';
            echo '<div class="error-content text-center">';
                if( ! empty( consua_opt( 'consua_coming_soon_image', 'url' ) ) ){
                    echo '<div class="error-img">';
                        echo consua_img_tag( array(
                            'url'   => esc_url( consua_opt( 'consua_coming_soon_image', 'url' ) ),
                        ) );
                    echo '</div>';
                }
                echo '<div class="row justify-content-center">';
                    echo '<div class="col-xl-9">';
                        if( ! empty( $consuacoming_soontitle ) ){
                            echo '<h2 class="error-title">'.esc_html( $consuacoming_soontitle ).'</h2>';
                        }
                        if( ! empty( $consuacoming_soonsubtitle ) ){
                            echo '<p class="error-text px-xl-5">'.esc_html( $consuacoming_soonsubtitle ).'</p>';
                        }
                        echo '<a href="'.esc_url( home_url('/') ).'" class="vs-btn mask-btn"><span class="btn-text">'.esc_html( $consuacoming_soonbtntext ).'</span><span class="btn-text-mask">'.esc_html( $consuacoming_soonbtntext ).'</span></a>';

                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</section>';

    //footer
    get_footer();