<?php
// Block direct access
if (!defined('ABSPATH')) {
    exit();
}
/**
 * @Packge     : consua
 * @Version    : 1.0
 * @Author     : consua
 * @Author URI : https://themeforest.net/user/validthemes/portfolio
 *
 */

// enqueue css
function consua_common_custom_css()
{
    wp_enqueue_style('consua-color-schemes', get_template_directory_uri() . '/assets/css/color.schemes.css');

    $CustomCssOpt  = consua_opt('consua_css_editor');
    $preloader_display  =  consua_opt('consua_display_preloader');
    if ($CustomCssOpt) {
        $CustomCssOpt = $CustomCssOpt;
    } else {
        $CustomCssOpt = '';
    }

    $customcss = "";

    if (get_header_image()) {
        $consua_header_bg =  get_header_image();
    } else {
        if (consua_meta('page_breadcrumb_settings') == 'page' && is_page()) {
            if (!empty(consua_meta('breadcumb_image'))) {
                $consua_header_bg = consua_meta('breadcumb_image');
            }
        }
    }

    if (!empty($consua_header_bg)) {
        $customcss .= ".breadcrumb-area{
            background:url('{$consua_header_bg}')!important;
            background-position: center center !important;
            background-size: cover !important;
        }";
    }
    if (!empty($preloader_display)) {
        $consua_pre_img = consua_opt('consua_preloader_img', 'url');
        if (!empty(consua_opt('consua_preloader_img', 'url'))) {
            $customcss .= ".se-pre-con{
                background:url('{$consua_pre_img}')!important;
                text-align: center;
                position: absolute;
                left: 50%;
                top: 50%;
                -webkit-transform: translate(-50%, -50%);
                transform: translate(-50%, -50%);
                text-align: center;
                line-height: 1;
                width: 96px;
                height: 48px;
                display: inline-block;
                position: relative;
                background: #fff;
                border-radius: 48px 48px 0 0;
                -webkit-box-sizing: border-box;
                box-sizing: border-box;
                overflow: hidden;
                            }";
        }
    }

    // theme color
    $consuathemecolor = consua_opt('consua_theme_color');
    if (!empty($consuathemecolor)) {
        list($r, $g, $b) = sscanf($consuathemecolor, "#%02x%02x%02x");

        $consua_real_color = $r . ',' . $g . ',' . $b;
        if (!empty($consuathemecolor)) {
            $customcss .= ":root {
          --color-primary: rgb({$consua_real_color});
        }";
        }
    }
    // theme color secendary
    $consuathemecolor_sec = consua_opt('consua_theme_color_sec');
    if (!empty($consuathemecolor_sec)) {
        list($r, $g, $b) = sscanf($consuathemecolor_sec, "#%02x%02x%02x");

        $consua_real_color_sec = $r . ',' . $g . ',' . $b;
        if (!empty($consuathemecolor_sec)) {
            $customcss .= ":root {
          --color-secondary: rgb({$consua_real_color_sec});
        }";
        }
    }

    if (!empty($CustomCssOpt)) {
        $customcss .= $CustomCssOpt;
    }

    wp_add_inline_style('consua-color-schemes', $customcss);
}
add_action('wp_enqueue_scripts', 'consua_common_custom_css', 100);