<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget .
 *
 */
class Elementor_Consua_Banner_Widget  extends Widget_Base {

	public function get_name() {
		return 'consua_banner';
	}

	public function get_title() {
		return __( 'Banner', 'consua' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'consua_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Banner_section',
			[
				'label' 	=> __( 'Banner', 'consua' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'banner_style',
			[
				'label' 		=> __( 'Banner Style', 'consua' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'consua' ),
					'2' 		=> __( 'Style Two', 'consua' ),
					'3' 		=> __( 'Style Three', 'consua' ),
					'4' 		=> __( 'Style Four', 'consua' ),
					'5' 		=> __( 'Style Five', 'consua' ),
					'6' 		=> __( 'Style Six', 'consua' ),
				],
			]
		);

		
        $repeater = new Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 3,
				'label_block' 	=> true,
			]
        );

        $repeater->add_control(
			'slider_image',
			[
				'label' 		=> __( 'Slider Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'slider_shape',
			[
				'label' 		=> __( 'Slider Shape', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
        
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'consua' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Button Text', 'consua' )
			]
        );
        $repeater->add_control(
			'button_link',
			[
				'label' 		=> __( 'URL', 'consua' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'sliders',
			[
				'label' 		=> __( 'Sliders', 'consua' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'title_field' 	=> '{{{ title }}}',
				'condition' => [
                    'banner_style' => '1'
                ]
			]
		);



		$repeater = new Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );

        $repeater->add_control(
			'subtitle', [
				'label' 		=> __( 'Description', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 3,
				'label_block' 	=> true,
			]
        );

        $repeater->add_control(
			'slider_image',
			[
				'label' 		=> __( 'Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'slider_shape',
			[
				'label' 		=> __( 'Shape', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
        
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'consua' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Button Text', 'consua' )
			]
        );
        $repeater->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'consua' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'sliders_two',
			[
				'label' 		=> __( 'Sliders', 'consua' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'title_field' 	=> '{{{ title }}}',
				'condition' => [
                    'banner_style' => '2'
                ]
			]
		);

		$this->add_control(
			'banner_style_two_bg_shape',
			[
				'label' 		=> __( 'Background Shape', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
                    'banner_style' => '2'
                ]
			]
		);



		$this->add_control(
			'style_three_title', [
				'label' 		=> __( 'Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition' => [
                    'banner_style' => ['3']
                ]
			]
        );

        $this->add_control(
			'style_three_subtitle', [
				'label' 		=> __( 'Sub Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition' => [
                    'banner_style' => ['3']
                ]
			]
        );

        $this->add_control(
			'style_three_button_text',
			[
				'label' 	=> __( 'Button Text', 'consua' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Button Text', 'consua' ),
                'condition' => [
                    'banner_style' => ['3']
                ]
			]
        );

        $this->add_control(
			'style_three_button_link',
			[
				'label' 		=> __( 'Link', 'consua' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition' => [
                    'banner_style' => ['3']
                ]
			]
		);

        $this->add_control(
			'layout_three_front_image',
			[
				'label' 		=> __( 'Front Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
                    'banner_style' => ['3']
                ]
			]
		);

		$this->add_control(
			'layout_three_shape_image',
			[
				'label' 		=> __( 'Shape Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
                    'banner_style' => ['3']
                ]
			]
		);

		$slider_four = new Repeater();

		$slider_four->add_control(
			'title', [
				'label' 		=> __( 'Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );

        $slider_four->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );

        $slider_four->add_control(
			'summary', [
				'label' 		=> __( 'Summary', 'evona' ),
				'type' 			=> Controls_Manager::CODE,
				'placeholder' 	=> esc_html__( 'summary', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Summary', 'consua-core' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );

        $slider_four->add_control(
			'slider_image',
			[
				'label' 		=> __( 'Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$slider_four->add_control(
			'slider_shape',
			[
				'label' 		=> __( 'Shape', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
        
        $slider_four->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'consua' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 1,
                'default'  	=> __( 'Button Label', 'consua' )
			]
        );

        $slider_four->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'consua' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'sliders_four',
			[
				'label' 		=> __( 'Sliders', 'consua' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $slider_four->get_controls(),
				'title_field' 	=> '{{{ title }}}',
				'prevent_empty' => 'false',
				'condition' => [
                    'banner_style' => '4'
                ]
			]
		);

		$slider_five = new Repeater();

		$slider_five->add_control(
			'title', [
				'label' 		=> __( 'Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );

        $slider_five->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );

        $slider_five->add_control(
			'slider_image',
			[
				'label' 		=> __( 'Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

		$slider_five->add_control(
			'slider_shape',
			[
				'label' 		=> __( 'Shape', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
        
        $slider_five->add_control(
			'video_text',
			[
				'label' 	=> __( 'Video Text', 'consua' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 1,
                'default'  	=> __( 'Video Label', 'consua' )
			]
        );
        $slider_five->add_control(
			'video_link',
			[
				'label' 		=> __( 'Video Link', 'consua' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'sliders_five',
			[
				'label' 		=> __( 'Sliders', 'consua' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $slider_five->get_controls(),
				'title_field' 	=> '{{{ title }}}',
				'prevent_empty' => false,
				'condition' => [
                    'banner_style' => '5'
                ]
			]
		);

		$this->add_control(
			'style_five_bac_image',
			[
				'label' 		=> __( 'Background Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
                    'banner_style' => ['5']
                ]
			]
		);



		$this->add_control(
			'style_six_title', [
				'label' 		=> __( 'Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
        );

        $this->add_control(
			'style_six_subtitle', [
				'label' 		=> __( 'Sub Title', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'label_block' 	=> true,
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
        );

         $this->add_control(
			'style_six_summary', [
				'label' 		=> __( 'Summary', 'evona' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'summary', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Summary', 'consua-core' ),
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
        );

        $this->add_control(
			'style_six_button_label', [
				'label' 		=> __( 'Button Label', 'evona' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'button label', 'consua-core' ),
				'default' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
        );

        $this->add_control(
			'style_six_button_link',
			[
				'label' 		=> __( 'Link', 'consua' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
		);

		 $this->add_control(
			'layout_six_image_one',
			[
				'label' 		=> __( 'Image One', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
		);

		$this->add_control(
			'layout_six_image_two',
			[
				'label' 		=> __( 'Image Two', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
		);

		$this->add_control(
			'layout_six_shape_image',
			[
				'label' 		=> __( 'Shape Image', 'consua' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
                    'banner_style' => ['6']
                ]
			]
		);
        
        
		$this->add_control(
			'nav_show',
			[
				'label' => __( 'Show/Hide Nav Icon', 'cleanu-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'cleanu-core' ),
				'label_off' => __( 'Hide', 'cleanu-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
                    'banner_style' => ['1','2','5']
                ]
			]
		);
		
		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'banner-style.php';
    }

	protected function render() {

        $consua_banner = $this->get_settings_for_display();

		if( $consua_banner['banner_style'] == '1' ){ ?>

	    <!-- Start Banner Area One
	    ============================================= -->
	    <div class="banner-area banner-style-one shadow navigation-custom-large zoom-effect overflow-hidden text-light">
	        <!-- Slider main container -->
	        <div class="banner-fade">
	            <!-- Additional required wrapper -->
	            <div class="swiper-wrapper">

	            	<?php foreach($consua_banner['sliders'] as $single_slider):?>
		                <!-- Single Item -->
		                <div class="swiper-slide banner-style-one">
		                    <div class="banner-thumb bg-cover shadow dark" style="background: url(<?php echo esc_url($single_slider['slider_image']['url']);?>);"></div>
		                    <div class="container">
		                        <div class="row align-center">
		                            <div class="col-xl-7 offset-lg-5">
		                                <div class="content">
		                                    <h4><?php echo htmlspecialchars_decode(esc_html($single_slider['subtitle'],'consua-core')); ?></h4>
		                                    <h2><?php echo htmlspecialchars_decode(esc_html($single_slider['title'],'consua-core')); ?></h2>
		                                    <?php if(!empty($single_slider['button_text'])):?>
			                                    <div class="button mt-40">
			                                        <a class="btn-animation" href="<?php echo esc_url($single_slider['button_link']['url']);?>"><i class="fas fa-arrow-right"></i> <span><?php echo esc_html($single_slider['button_text']);?></span></a>
			                                    </div>
		                                    <?php endif;?>
		                                </div>
		                            </div>
		                        </div>
		                    </div>
		                    <?php if(!empty($single_slider['slider_shape']['url'])):?>
			                    <!-- Shape -->
			                    <div class="banner-shape-bg">
			                        <img src="<?php echo esc_url($single_slider['slider_shape']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                    </div>
			                    <!-- End Shape -->
			                <?php endif;?>
		                </div>
		                <!-- End Single Item -->
	                <?php endforeach;?>
	            </div>
				<?php if($consua_banner['nav_show'] == 'yes'): ?>
		            <!-- Pagination -->
		            <div class="swiper-pagination"></div>
				<?php endif;?>
	        </div>  
	    </div>
	    <!-- End Banner Area One -->	
			
		<?php }elseif( $consua_banner['banner_style'] == '2' ){ ?>

		<!-- Start Banner Area Style Two
	    ============================================= -->
		<div class="banner-area banner-style-two content-right navigation-icon-solid navigation-right-botom navigation-custom-large overflow-hidden bg-cover" style="background: url(<?php echo esc_url($consua_banner['banner_style_two_bg_shape']['url']);?>);">
	        <!-- Slider main container -->
	        <div class="banner-style-two-carousel">
	            <!-- Additional required wrapper -->
	            <div class="swiper-wrapper">
					<?php foreach($consua_banner['sliders_two'] as $single_slider):?>
		                <!-- Single Item -->
		                <div class="swiper-slide banner-style-two">
		                    <div class="container">
		                        <div class="row align-center">
		                            <div class="col-xl-7 col-lg-9">
		                                <div class="content">
		                                    <h2><?php echo wp_kses_post($single_slider['title'],'consua_kses_allowed_html');?></h2>
		                                    <p>
		                                       <?php echo wp_kses_post($single_slider['subtitle'],'consua_kses_allowed_html');?>
		                                    </p>
		                                    <?php if(!empty($single_slider['button_link']['url'])):?>
			                                    <div class="button">
			                                        <a class="btn circle btn-theme btn-md radius animation" href="<?php echo esc_url($single_slider['button_link']['url']);?>"><?php echo esc_html($single_slider['button_text']);?>
			                                        </a>
			                                    </div>
		                                	<?php endif;?>
		                                    <div class="shape-circle"></div>
		                                </div>
		                            </div>
		                        </div>
		                        <?php if(!empty($single_slider['slider_image']['url'])):?>
			                        <!-- Banner Thumb -->
			                        <div class="banner-thumb">
			                            <img src="<?php echo esc_url($single_slider['slider_image']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                        </div>
			                        <!-- End Banner Thumb -->
		                        <?php endif;?>
		                    </div>
		                    <?php if(!empty($single_slider['slider_shape']['url'])):?>
			                    <!-- Start Shape -->
			                    <div class="banner-shape-right" style="background: url(<?php echo esc_url($single_slider['slider_shape']['url']);?>);"></div>
			                    <!-- End Shape -->
		                	<?php endif;?>
		                </div>
		                <!-- End Single Item -->
	  				<?php endforeach;?>   
	            </div>
				<?php if($consua_banner['nav_show'] == 'yes'): ?>
		            <!-- Navigation -->
		            <div class="swiper-nav-left">
		                <div class="swiper-button-prev"></div>
		                <div class="swiper-button-next"></div>
		            </div>
				<?php endif;?>
	        </div>        
	    </div>
	    <!-- End Banner Style Two-->

		<?php }elseif( $consua_banner['banner_style'] == '3' ){ ?>

		<!-- Start Banner Style Three
	    ============================================= -->
	    <div class="banner-style-four-area text-light bg-cover" style="background-image: url(<?php echo esc_url($consua_banner['layout_three_shape_image']['url']);?>);">

	        <!-- Single Item -->
	        <div class="banner-style-four">
	            <div class="container">
	                <div class="content">
	                    
	                    <div class="row align-center">
	                        <div class="col-xl-6 col-lg-7 pr-50 pr-md-15 pr-xs-15">
	                            <div class="information">
	                                <h2 class="wow fadeInUp" data-wow-delay="500ms" data-wow-duration="400ms">
	                                   <?php echo wp_kses($consua_banner['style_three_title'], 'consua_allowed_tags'); ?>
	                                </h2>
	                                <p class="wow fadeInUp"  data-wow-delay="900ms" data-wow-duration="400ms">
	                                   <?php echo wp_kses($consua_banner['style_three_subtitle'], 'consua_allowed_tags'); ?>
	                                </p>
	                                <?php if(!empty($consua_banner['style_three_button_text'])):?>
		                                <div class="button mt-30 wow fadeInUp"  data-wow-delay="1200ms" data-wow-duration="400ms">
		                                    <a class="btn-animation" href="<?php echo esc_url($consua_banner['style_three_button_link']['url']);?>"><i class="fas fa-arrow-right"></i> <span> <?php echo wp_kses($consua_banner['style_three_button_text'], 'consua_allowed_tags'); ?></span></a>
		                                </div>
	                            	<?php endif;?>
	                            </div>
	                        </div>

	                        <?php if(!empty($consua_banner['layout_three_front_image']['url'])):?>
		                        <div class="col-xl-6 col-lg-5 pl-60 pl-md-15 pl-xs-15">
		                            <div class="thumb">
		                                <img src="<?php echo esc_url($consua_banner['layout_three_front_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
		                            </div>
		                        </div>
	                        <?php endif;?>
	                    </div>
	                </div>
	            </div>
	        </div>
	        <!-- End Single Item -->
	    </div>
	    <!-- End Banner Style Three -->	

		<?php }elseif( $consua_banner['banner_style'] == '4' ){ ?>

	    <!-- Start Banner Area Four
	    ============================================= -->
	    <div class="banner-area bg-gray navigation-circle banner-style-three-area overflow-hidden">
	        <!-- Slider main container -->
	        <div class="banner-style-two-carousel">
	            <!-- Additional required wrapper -->
	            <div class="swiper-wrapper">
					<?php foreach($consua_banner['sliders_four'] as $single_slider):?>
		                <!-- Single Item -->
		                <div class="swiper-slide banner-style-three">
		                    <div class="banner-thumb bg-cover" style="background: url(<?php echo esc_url($single_slider['slider_image']['url']);?>);"></div>
		                    <div class="container">
		                        <div class="row align-center">
		                            <div class="col-xl-6 col-lg-7 col-md-10">
		                                <div class="content">
		                                    <h4><?php echo wp_kses($single_slider['subtitle'], 'consua_allowed_tags'); ?></h4>
		                                    <h2><?php echo wp_kses($single_slider['title'], 'consua_allowed_tags'); ?></h2>
		                                   	<?php echo wp_kses($single_slider['summary'], 'consua_allowed_tags'); ?>
		                                   	<?php if(!empty($single_slider['button_link']['url'])):?>
			                                    <div class="button">
			                                        <a class="btn btn-theme secondary btn-md animation" href="<?php echo esc_url($single_slider['button_link']['url']);?>"><?php echo wp_kses($single_slider['button_text'], 'consua_allowed_tags'); ?></a>
			                                    </div>
		                                	<?php endif;?>
		                                </div>
		                            </div>
		                        </div>
		                    </div>
		                    <?php if(!empty($single_slider['slider_shape']['url'])):?>
			                    <div class="banner-shape">
			                        <img src="<?php echo esc_url($single_slider['slider_shape']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                    </div>
		                	<?php endif;?>
		                </div>
		                <!-- End Single Item -->
					<?php endforeach;?>
	            </div>
	            <?php if($consua_banner['nav_show'] == 'yes'): ?>
		            <!-- Navigation -->
		            <div class="swiper-button-prev"></div>
		            <div class="swiper-button-next"></div>
				<?php endif;?>
	        </div>        
	    </div>
	    <!-- End Banner Area Four -->

	    <?php }elseif( $consua_banner['banner_style'] == '5' ){ ?>

	    <!-- Start Banner Area Five
	    ============================================= -->
	    <div class="banner-area banner-solar navigation-circle overflow-hidden" style="background: url(<?php echo esc_url($consua_banner['style_five_bac_image']['url']);?>);">
	        <!-- Slider main container -->
	        <div class="banner-fade">
	            <!-- Additional required wrapper -->
	            <div class="swiper-wrapper">

	            	<?php foreach($consua_banner['sliders_five'] as $single_slider):?>
		                <!-- Single Item -->
		                <div class="swiper-slide banner-style-five">
		                    <div class="banner-thumb bg-cover" style="background: url(<?php echo esc_url($single_slider['slider_image']['url']);?>);"></div>
		                    <div class="container">
		                        <div class="row align-center">
		                            <div class="col-xl-7">
		                                <div class="content">
		                                    <h4><?php echo wp_kses($single_slider['subtitle'], 'consua_allowed_tags'); ?></h4>
		                                    <h2><?php echo wp_kses($single_slider['title'], 'consua_allowed_tags'); ?></h2>
		                                    <?php if(!empty($single_slider['video_link']['url'])):?>
			                                    <div class="button">
			                                        <a href="<?php echo esc_url($single_slider['video_link']['url']);?>" class="popup-youtube video-play-button with-text mt-20">
			                                            <div class="effect"></div>
			                                            <span><i class="fas fa-play"></i> <?php echo wp_kses($single_slider['video_text'], 'consua_allowed_tags'); ?></span>
			                                        </a>
			                                    </div>
		                                	<?php endif;?>
		                                </div>
		                            </div>
		                        </div>
		                    </div>

		                    <?php if(!empty($single_slider['slider_shape']['url'])):?>
			                    <!-- Shape -->
			                    <div class="banner-shape-bg">
			                        <img src="<?php echo esc_url($single_slider['slider_shape']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
			                    </div>
			                    <!-- End Shape -->
		                	<?php endif;?>

		                </div>
		                <!-- End Single Item -->
					<?php endforeach;?>

	            </div>

	            <?php if($consua_banner['nav_show'] == 'yes'): ?>
		            <!-- Navigation -->
		            <div class="swiper-button-prev"></div>
		            <div class="swiper-button-next"></div>
		        <?php endif;?>

	        </div>  
	    </div>
	    <!-- End Banner Area Five -->

	    <?php }elseif( $consua_banner['banner_style'] == '6' ){ ?>

		<!-- Start Banner Area Six
	    ============================================= -->
		    <div class="banner-style-six-area text-light bg-cover" style="background-image: url(<?php echo esc_url($consua_banner['layout_six_shape_image']['url']);?>);">

		        <!-- Single Item -->
		        <div class="banner-style-six">
		            <div class="container">
		                <div class="content">
		                    
		                    <div class="row align-center">
		                        <div class="col-xl-6 col-lg-7 pr-80 pr-md-15 pr-xs-15">
		                            <div class="information mt--100 mt-md-0 mt-xs-0">
		                                <h4 class="wow fadeInUp" data-wow-delay="300ms" data-wow-duration="200ms"> <?php echo wp_kses($consua_banner['style_six_subtitle'], 'consua_allowed_tags'); ?></h4>
		                                <h2 class="wow fadeInUp" data-wow-delay="500ms" data-wow-duration="400ms">
		                                   <?php echo wp_kses($consua_banner['style_six_title'], 'consua_allowed_tags'); ?>
		                                </h2>
		                                <p class="wow fadeInUp"  data-wow-delay="900ms" data-wow-duration="400ms">
		                                    <?php echo wp_kses($consua_banner['style_six_summary'], 'consua_allowed_tags'); ?>
		                                </p>
		                                <?php if(!empty($consua_banner['style_six_button_link']['url'])):?>
			                                <div class="button mt-30 wow fadeInUp"  data-wow-delay="1200ms" data-wow-duration="400ms">
			                                    <a class="btn-animation" href="<?php echo esc_url($consua_banner['style_six_button_link']['url']);?>"><i class="fas fa-arrow-right"></i> <span><?php echo wp_kses($consua_banner['style_six_button_label'], 'consua_allowed_tags'); ?></span></a>
			                                </div>
		                            	<?php endif; ?>
		                            </div>
		                        </div>

		                        <div class="col-xl-6 col-lg-5 pl-60 pl-md-15 pl-xs-15">
		                            <div class="thumb">
		                            	<?php if(!empty($consua_banner['layout_six_image_one']['url'])):?>
		                                	<img src="<?php echo esc_url($consua_banner['layout_six_image_one']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
		                            	<?php endif;?>
		                            	<?php if(!empty($consua_banner['layout_six_image_two']['url'])):?>
		                                	<img src="<?php echo esc_url($consua_banner['layout_six_image_two']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
		                                <?php endif;?>
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		        <!-- End Single Item -->
		    </div>
	    <!-- End Banner Area Six -->

		<?php 
		}
	}
}