<?php
	/**
	* Elementor Blog Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Blog_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Blog widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_blog';
	}

	/**
	* Get widget title.
	*
	* Retrieve Blog widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Consua Blog', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Blog widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/

	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Blog widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}

	
	protected function register_controls(){

		$this->start_controls_section(
			'blog_section_content',
			[
				'label'		=> esc_html__( 'Set Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
					'3'  	=> esc_html__( 'Style Three', 'consua-core' ),
					'4'  	=> esc_html__( 'Style Four', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> esc_html__( 'Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Title', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> esc_html__( 'Sub-Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section SubTitle', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'post_from',
			[
				'label' 		=> esc_html__( 'Post From', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'default' 		=> 'all',
				'options' 		=> [
					'all'  			=> esc_html__( 'All', 'consua-core' ),
					'categories' 	=> esc_html__( 'Categories', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'post_limit',
			[
				'label' 		=> esc_html__( 'Post Limit', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Only Number Work. Like 4 or 6', 'consua-core' ),
			]
		);

		$this->add_control(
			'order',
			[
				'label' 		=> esc_html__( 'Order', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'default' 		=> 'ASC',
				'options' 		=> [
					'ASC'  			=> esc_html__( 'Ascending', 'consua-core' ),
					'DESC' 			=> esc_html__( 'Descending', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'order_by',
			[
				'label' 		=> esc_html__( 'Order By', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'default' 		=> 'date',
				'options' 		=> [
					'none'  		=> esc_html__( 'None', 'consua-core' ),
					'type' 			=> esc_html__( 'Type', 'consua-core' ),
					'title' 		=> esc_html__( 'Title', 'consua-core' ),
					'name' 			=> esc_html__( 'Name', 'consua-core' ),
					'date' 			=> esc_html__( 'Date', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'content_length',
			[
				'label' 		=> esc_html__( 'Content Length', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '16',
				'placeholder' 	=> esc_html__( 'Type Content Length', 'consua-core' ),
			]
		);

		$this->add_control(
			'read_more',
			[
				'label' 		=> esc_html__( 'Read More Text', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'read more text', 'consua-core' ),
				'default' 		=> esc_html__( 'Read More', 'consua-core' ),
			]
		);


		$this->end_controls_section();
		
	}


	protected function render(){
		
		$consua_blog_output = $this->get_settings_for_display();
		global $post;
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$blog = array(
		   'post_type'         => 'post',
		   'posts_per_page'    => esc_attr( $consua_blog_output['post_limit'] ),
		   'order'             => esc_attr( $consua_blog_output['order'] ),
		   'orderby'           => esc_attr( $consua_blog_output['order_by'] ),
		   'paged' => $paged,
	    );
	    $consua_blog = new WP_Query( $blog );
	    if($consua_blog_output['style'] == '1'):
	?>
    <!-- Start Blog Area
    ============================================= -->
    <div class="home-blog-area default-padding bottom-less">
        <?php if(!empty($consua_blog_output['section_title'] || $consua_blog_output['section_subtitle'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                       	<h4 class="sub-heading"><?php echo wp_kses($consua_blog_output['section_subtitle'], 'consua_allowed_tags'); ?></h4>
	                        <h2 class="title"><?php echo wp_kses($consua_blog_output['section_title'], 'consua_allowed_tags'); ?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">
            	<?php 
            		$counter = 1;
            		while ( $consua_blog->have_posts()) :
       				$consua_blog->the_post();
					$consua_blog_one_img_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'full');
       			?>
	                <!-- Single Item -->
	                <div class="col-xl-4 col-md-6 mb-30 wow fadeInUp" data-wow-delay="300ms">
	                    <div class="blog-style-one<?php if(!has_post_thumbnail()){echo esc_attr__(" thumbless",'consua');}?>">
	                    	<?php if(!empty($consua_blog_one_img_url[0])):?>
		                        <div class="thumb">
		                            <a href="<?php echo  esc_url( get_permalink() ); ?>">
		                            	<img src="<?php echo esc_url($consua_blog_one_img_url[0]);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                            </a>
		                        </div>
	                    	<?php endif;?>
	                        <div class="info">
	                            <div class="blog-meta">
	                               <ul>
	                                    <li>
	                                        <span><?php echo esc_attr("By",'consua');?> </span>
	                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta('ID') ) );?>"> <?php echo esc_html( ucwords( get_the_author() ) );?></a>
	                                    </li>
	                                    <li>
	                                     	<?php echo get_the_date();?>
	                                    </li>
	                               </ul>
	                            </div>
	                            <h4>
	                                <a href="<?php echo  esc_url( get_permalink() ); ?>"><?php echo esc_html(get_the_title());?></a>
	                            </h4>
	                            <a href="<?php echo  esc_url( get_permalink() ); ?>" class="btn-simple"><i class="fas fa-angle-right"></i> <?php echo wp_kses($consua_blog_output['read_more'], 'consua_allowed_tags'); ?></a>
	                        </div>
	                    </div>
	                </div>
	                <!-- End Single Item -->
                <?php $counter++; endwhile; wp_reset_postdata();?>
            </div>
        </div>
    </div>
    <!-- End Blog Area -->

	<?php elseif($consua_blog_output['style'] == '2'):?>

	<!-- Start Blog 
    ============================================= -->
    <div class="home-blog-area default-padding">
        <?php if(!empty($consua_blog_output['section_title'] || $consua_blog_output['section_subtitle'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                       	<h4 class="sub-heading"><?php echo wp_kses($consua_blog_output['section_subtitle'], 'consua_allowed_tags'); ?></h4>
	                        <h2 class="title"><?php echo wp_kses($consua_blog_output['section_title'], 'consua_allowed_tags'); ?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">
                <!-- Single Item -->
                <div class="col-lg-6">
                	<?php 
		        		$counter_blog = 1;
		        		while ( $consua_blog->have_posts()) :
		   				$consua_blog->the_post();
						$consua_blog_one_img_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'consua_598X673');
						if($counter_blog == 1):
						$tag_name = get_the_tags();
		   			?>
	                    <div class="blog-style-one solid<?php if(!has_post_thumbnail()){echo esc_attr__(" thumbless",'consua');}?>">
	                        <div class="thumb">
	                        	<?php if(!empty($consua_blog_one_img_url[0])):?>
	                            	<img src="<?php echo esc_url($consua_blog_one_img_url[0]);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                        	<?php endif;?>
	                            <?php if(has_tag()) :?>
		                            <div class="tags">
		                            	<a href="<?php echo esc_url(get_tag_link( $tag_name[0]->term_id ) );?>"><?php echo esc_html($tag_name[0]->name); ?></a>
		                            </div>
	                        	<?php endif;?>
	                            <div class="info">
	                                <div class="blog-meta">
	                                    <ul>
	                                        <li>
	                                            <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta('ID') ) );?>"><i class="fas fa-user"></i> <?php echo esc_html( ucwords( get_the_author() ) );?></a>
	                                        </li>
	                                        <li>
	                                            <?php echo get_the_date();?>
	                                        </li>
	                                    </ul>
	                                 </div>
	                                <h4>
	                                    <a href="<?php echo  esc_url( get_permalink() ); ?>"><?php echo esc_html(get_the_title());?></a>
	                                </h4>
	                                <p>
	                                    <?php echo esc_html(wp_trim_words(get_the_content(),$consua_blog_output['content_length'],'')); ?>
	                                </p>
	                            </div>
	                        </div>
	                    </div>
                    <?php endif; $counter_blog++; endwhile; wp_reset_postdata();?>
                </div>
                <!-- End Single Item -->
                <!-- Single Item -->
                <div class="col-lg-6 mt-md-30 mt-xs-30">

                  	<?php 
		        		$counter = 1;
		        		while ( $consua_blog->have_posts()) :
		   				$consua_blog->the_post();
						$consua_blog_one_img_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'consua_598X321');
						if($counter == 2 || $counter == 3):
						$tag_name = get_the_tags();
		   			?>
	                    <div class="blog-style-one solid <?php if($counter == '2'){echo esc_attr("mb-30");}?>">
	                        <div class="thumb">
	                        	<?php if(!empty($consua_blog_one_img_url[0])):?>
	                            	<img src="<?php echo esc_url($consua_blog_one_img_url[0]);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                        	<?php endif;?>
	                            <?php if(has_tag()) :?>
		                            <div class="tags">
		                            	<a href="<?php echo esc_url(get_tag_link( $tag_name[0]->term_id ) );?>"><?php echo esc_html($tag_name[0]->name); ?></a>
		                            </div>
	                        	<?php endif;?>
	                            <div class="info">
	                                <div class="blog-meta">
	                                    <ul>
	                                        <li>
	                                            <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta('ID') ) );?>"><i class="fas fa-user"></i> <?php echo esc_html( ucwords( get_the_author() ) );?></a>
	                                        </li>
	                                        <li>
	                                            <?php echo get_the_date();?>
	                                        </li>
	                                    </ul>
	                                 </div>
	                                <h4>
	                                    <a href="<?php echo  esc_url( get_permalink() ); ?>"><?php echo esc_html(get_the_title());?></a>
	                                </h4>
	                            </div>
	                        </div>
	                    </div>
                	<?php endif; $counter++; endwhile; wp_reset_postdata();?>
                </div>
                <!-- End Single Item -->
            </div>
        </div>
    </div>
    <!-- End Blog  -->


	<?php elseif($consua_blog_output['style'] == '3'):?>

	<!-- Start Blog 
    ============================================= -->
    <div class="blog-area blog-grid">
        <div class="container">
            <div class="blog-item-box">
                <div class="row">
            	<?php 
        		$counter = 1;
        		while ( $consua_blog->have_posts()) :
   				$consua_blog->the_post();
				$consua_blog_one_img_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'consua_359X259');
       			?>
                    <!-- Single Item -->
                    <div class="col-xl-4 col-md-6 single-item">
                        <div class="blog-style-one">
                        	<?php if(!empty($consua_blog_one_img_url[0])):?>
	                            <div class="thumb">
	                                <a href="<?php echo  esc_url( get_permalink() ); ?>">
		                            	<img src="<?php echo esc_url($consua_blog_one_img_url[0]);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                            </a>
	                            </div>
                        	<?php endif;?>
                            <div class="info">
                                <div class="blog-meta">
                                   <ul>
                                        <li>
	                                        <span><?php echo esc_attr("By",'consua');?> </span>
	                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta('ID') ) );?>"> <?php echo esc_html( ucwords( get_the_author() ) );?></a>
	                                    </li>
	                                    <li>
	                                     	<?php echo get_the_date();?>
	                                    </li>
                                   </ul>
                                </div>
                                <h3>
                                   <a href="<?php echo  esc_url( get_permalink() ); ?>"><?php echo esc_html(get_the_title());?></a>
                                </h3>
                                <a href="<?php echo  esc_url( get_permalink() ); ?>" class="btn-simple"><i class="fas fa-angle-right"></i> <?php echo wp_kses($consua_blog_output['read_more'], 'consua_allowed_tags'); ?></a>
                            </div>
                        </div>
                    </div>
                    <!-- Single Item -->
                 <?php $counter++; endwhile; wp_reset_postdata();?>   
                </div>
            </div>
	            <!-- Pagination -->
	            <div class="row">
	                <div class="col-md-12 pagi-area text-center">
	                    <nav aria-label="navigation">
							<?php
				                echo "<div class='pagination'>" . paginate_links(array(
				                    'total' => $consua_blog->max_num_pages,
				                    'prev_text' => __('<div class="preious-page"><i class="fas fa-angle-double-left"></i></div>'),
				                    'next_text' => __('<div class="next-page"><i class="fas fa-angle-double-right"></i></div>')
				                )) . "</div>";
				            ?>
	                    </nav>
	                </div>
	            </div>
	            <!-- End Pagination -->
        </div>
    </div>
    <!-- End Blog -->

    <?php elseif($consua_blog_output['style'] == '4'):?>

    <!-- Start Blog 
    ============================================= -->
    <div class="blog-area blog-grid">
        <div class="container">
            <div class="blog-item-box">
                <div class="row">
            	<?php 
	        		$counter = 1;
	        		while ( $consua_blog->have_posts()) :
	   				$consua_blog->the_post();
					$consua_blog_one_img_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'full');
       			?>
                    <!-- Single Item -->
                    <div class="col-xl-6 col-md-6 single-item">
                        <div class="blog-style-one">
                        	<?php if(!empty($consua_blog_one_img_url[0])):?>
	                            <div class="thumb">
	                                <a href="<?php echo  esc_url( get_permalink() ); ?>">
		                            	<img src="<?php echo esc_url($consua_blog_one_img_url[0]);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                            </a>
	                            </div>
                        	<?php endif;?>
                            <div class="info">
                                <div class="blog-meta">
                                   <ul>
                                      	<li>
	                                        <span><?php echo esc_attr("By",'consua');?> </span>
	                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta('ID') ) );?>"> <?php echo esc_html( ucwords( get_the_author() ) );?></a>
	                                    </li>
	                                    <li>
	                                     	<?php echo get_the_date();?>
	                                    </li>
                                   </ul>
                                </div>
                                <h3>
                                   <a href="<?php echo  esc_url( get_permalink() ); ?>"><?php echo esc_html(get_the_title());?></a>
                                </h3>
                                <a href="<?php echo  esc_url( get_permalink() ); ?>" class="btn-simple"><i class="fas fa-angle-right"></i> <?php echo wp_kses($consua_blog_output['read_more'], 'consua_allowed_tags'); ?></a>
                            </div>
                        </div>
                    </div>
                    <!-- Single Item -->
                <?php $counter++; endwhile; wp_reset_postdata();?>      
                </div>
            </div>
            <!-- Pagination -->
            <div class="row">
                <div class="col-md-12 pagi-area text-center">
                    <nav aria-label="navigation">
                       <?php
			                echo "<div class='pagination'>" . paginate_links(array(
			                    'total' => $consua_blog->max_num_pages,
			                    'prev_text' => __('<div class="preious-page"><i class="fas fa-angle-double-left"></i></div>'),
			                    'next_text' => __('<div class="next-page"><i class="fas fa-angle-double-right"></i></div>')
			                )) . "</div>";
			            ?>
                    </nav>
                </div>
            </div>
            <!-- End Pagination -->
        </div>
    </div>
    <!-- End Blog -->

    <?php 
	endif;
	}
}
