<?php
	/**
	* Elementor consua Choose Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Choose_Us_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Choose widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_choose_us';
	}

	/**
	* Get widget title.
	*
	* Retrieve Choose Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Choose Us', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Choose Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Choose Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'choose_us_style',
			[
				'label'		=> esc_html__( 'Choose Content Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'choose_image',
			[
				'label'			=> esc_html__( 'Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'shape_image',
			[
				'label'			=> esc_html__( 'Shape','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'heading', [
				'label' 		=> esc_html__( 'Heading', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'bottom_text', [
				'label' 		=> esc_html__( 'Bottom Text', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> '1',
				'label_block' 	=> true,
			]
		);



		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'choose_list',
			[
				'label' 	=> esc_html__( 'Choose Us List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'prevent_empty' => 'false',
				'title_field' => '{{{ title }}}',
			]
		);

		
		$this->end_controls_section();
	}

	// Output For User
	protected function render(){	
	$consua_choose_us_output = $this->get_settings_for_display();
	?>
    <!-- Start Why Choose Us
    ============================================= -->
    <div class="choose-us-style-one-area default-padding text-light">
        <div class="cover-bg" style="background-image: url(<?php echo esc_url($consua_choose_us_output['choose_image']['url']);?>);"></div>
        <?php if($consua_choose_us_output['shape_image']['url']):?>
	        <div class="shape-left-top">
	            <?php 
		        	echo consua_img_tag( array(
			            'url'   => esc_url( $consua_choose_us_output['shape_image']['url'] )
			    	) );
			    ?>
	        </div>
    	<?php endif; ?>
        <?php if(!empty($consua_choose_us_output['bottom_text'])): ?>
        	<div class="text-invisible"><?php echo esc_html($consua_choose_us_output['bottom_text']);?></div>
        <?php endif; ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 pr-80 pr-md-15 pr-xs-15">
                    <div class="choose-us-style-one">
                    	<?php if(!empty($consua_choose_us_output['heading'])): ?>
                        	<h2 class="title mb-35"><?php echo esc_html($consua_choose_us_output['heading']);?></h2>
                    	<?php endif; ?>
                        <ul class="list-item">
							<?php foreach($consua_choose_us_output['choose_list'] as $item): ?>
	                            <li class="wow fadeInUp">
	                            	<?php if(!empty($item['title'])):?>
	                                	<h4><?php echo esc_html($item['title']);?></h4>
	                            	<?php endif;?>
	                            	<?php if(!empty($item['title'])):?>
		                                <p>
		                                   <?php echo esc_html($item['subtitle']);?>
		                                </p>
	                                <?php endif;?>
	                            </li>
                         	<?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Why Choose Us -->
    <?php
    }
}