<?php
	/**
	* Elementor Contact Form Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Contact_Form_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Contact Form widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_contact_form';
	}

	/**
	* Get widget title.
	*
	* Retrieve Contact Form widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Contact', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve contact_formor widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the contact_formor widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		

		$this->start_controls_section(
			'contact_form_content',
			[
				'label'		=> esc_html__( 'Set Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
					'3'  	=> esc_html__( 'Style Three', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> esc_html__( 'Sub-Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Sub Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'info', [
				'label' 		=> esc_html__( 'Information', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$repeater->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => Consua_flaticons(),
                'include'    => Consua_include_flaticons(),
                'default'    => 'flaticon-vegetables',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$repeater->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$repeater->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$this->add_control(
			'contact_info_list',
			[
				'label' 	=> esc_html__( 'Contact Info List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Contact Info', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => ['1','2']
                ],
				'prevent_empty' => false
			]
		);

		$this->add_control(
			'form_title', [
				'label' 		=> esc_html__( 'Form Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
				'condition' => [
                    'style' => ['1','2']
                ]
			]
		);

		$this->add_control(
			'form_subtitle', [
				'label' 		=> esc_html__( 'Form Sub-Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Sub Title', 'consua-core' ),
				'label_block' 	=> true,
				'condition' => [
                    'style' => ['1','2']
                ]
			]
		);

		$this->add_control(
			'contact_shortcode',
			[
				'label' 		=> esc_html__( 'Contact Form Shortcode', 'cleanu-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'placeholder' 	=> esc_html__( 'Put your shortcode Here', 'cleanu-core' ),
			]

		);

		$this->add_control(
			'contact_image',
			[
				'label'			=> esc_html__( 'Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
				'condition' => [
                    'style' => ['3']
                ]
			]
		);

		$this->add_control(
			'contact_shape',
			[
				'label'			=> esc_html__( 'Shape Image One','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'contact_shape_two',
			[
				'label'			=> esc_html__( 'Shape Image Two','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => '2'
                ]
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'contact-style.php';

		
	}

	// Output For User
	protected function render(){
	$consua_contact_form_output = $this->get_settings_for_display();
	if($consua_contact_form_output['style'] == '1'):
	?>
    <!-- Start Contact Us 
    ============================================= -->
    <div class="contact-style-one-area overflow-hidden default-padding">

		<?php if(!empty($consua_contact_form_output['contact_shape']['url'])):?>
	        <div class="contact-shape">
	            <img src="<?php echo esc_url($consua_contact_form_output['contact_shape']['url']);?>" alt="<?php echo get_bloginfo('name'); ?>">
	        </div>
	    <?php endif;?>
       
        <div class="container">
            <div class="row align-center">

                <div class="contact-stye-one col-lg-5 mb-md-50 mb-xs-20">

                    <div class="contact-style-one-info">
                    	<?php if(!empty($consua_contact_form_output['section_title'])):?>
                        	<h2><?php echo wp_kses($consua_contact_form_output['section_title'], 'consua_allowed_tags'); ?></h2>
                    	<?php endif ?>
                    	<?php if(!empty($consua_contact_form_output['section_subtitle'])):?>
	                        <p>
	                         <?php echo wp_kses($consua_contact_form_output['section_subtitle'], 'consua_allowed_tags'); ?>
	                        </p>
                        <?php endif ?>
                        <ul>
							<?php foreach($consua_contact_form_output['contact_info_list'] as $single_contact_info):?>
	                            <li class="wow fadeInUp">
	                                <div class="icon">
	                                   	<?php if(!empty($single_contact_info['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($single_contact_info['flat_icon']); ?>"></i>
					                    <?php endif;?>
					                    <?php if(!empty($single_contact_info['icon_image'])):?>
					                        <img src="<?php echo esc_url($single_contact_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
					                    <?php endif;?>
					                    <?php 
					                    if(!empty($single_contact_info['custom_icon'])):?>
					                        <i class="<?php echo esc_attr($single_contact_info['custom_icon']); ?>"></i>
					                    <?php endif;?>
	                                </div>
	                                <div class="content">
	                                	<h5 class="title"><?php echo wp_kses($single_contact_info['title'], 'consua_allowed_tags'); ?></h5>
	                                  	<?php echo wp_kses($single_contact_info['info'], 'consua_allowed_tags'); ?>
	                                </div>
	                            </li>
                           <?php endforeach?>
                        </ul>
                    </div>
                </div>
                
                <div class="contact-stye-one col-lg-7 pl-60 pl-md-15 pl-xs-15">
                    <div class="contact-form-style-one">
                    	<?php if(!empty($consua_contact_form_output['form_title'])):?>
	                        <h5 class="sub-title"><?php echo wp_kses($consua_contact_form_output['form_title'], 'consua_allowed_tags'); ?></h5>
	                    <?php endif;?>
	                    <?php if(!empty($consua_contact_form_output['form_subtitle'])):?>
                        	<h2 class="heading"><?php echo wp_kses($consua_contact_form_output['form_subtitle'], 'consua_allowed_tags'); ?></h2>
                        <?php endif;?>
                        <?php if(!empty($consua_contact_form_output['contact_shortcode'])):?>
                        	<?php echo do_shortcode($consua_contact_form_output['contact_shortcode']);?>
                        <?php endif;?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Contact -->

	<?php elseif($consua_contact_form_output['style'] == '2'): ?>

	 <!-- Start Contact Style Two 
    ============================================= -->
    <div class="contact-style-one-area overflow-hidden half-shape-top default-padding-bottom">

    	<?php if(!empty($consua_contact_form_output['contact_shape']['url'])):?>
	        <div class="contact-shape">
	            <img src="<?php echo esc_url($consua_contact_form_output['contact_shape']['url']);?>" alt="<?php echo get_bloginfo('name'); ?>">
	        </div>
    	<?php endif;?>
       
        <div class="container">
            <div class="row">

                <div class="contact-stye-one col-lg-5 pt-220 pt-md-120 pt-xs-50">

					<?php if(!empty($consua_contact_form_output['contact_shape_two']['url'])):?>
	                    <div class="shape-animated-arrow">
	                        <img src="<?php echo esc_url($consua_contact_form_output['contact_shape_two']['url']);?>" alt="<?php echo get_bloginfo('name'); ?>">
	                    </div>
					<?php endif;?>
                    <div class="contact-style-one-info">
                        <?php if(!empty($consua_contact_form_output['section_title'])):?>
                        	<h2><?php echo wp_kses($consua_contact_form_output['section_title'], 'consua_allowed_tags'); ?></h2>
                    	<?php endif ?>
                    	<?php if(!empty($consua_contact_form_output['section_subtitle'])):?>
	                        <p>
	                         <?php echo wp_kses($consua_contact_form_output['section_subtitle'], 'consua_allowed_tags'); ?>
	                        </p>
                        <?php endif ?>
                        <ul>
							<?php foreach($consua_contact_form_output['contact_info_list'] as $single_contact_info):?>
	                            <li class="wow fadeInUp">
	                                <div class="icon">
	                                   	<?php if(!empty($single_contact_info['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($single_contact_info['flat_icon']); ?>"></i>
					                    <?php endif;?>
					                    <?php if(!empty($single_contact_info['icon_image'])):?>
					                        <img src="<?php echo esc_url($single_contact_info['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
					                    <?php endif;?>
					                    <?php 
					                    if(!empty($single_contact_info['custom_icon'])):?>
					                        <i class="<?php echo esc_attr($single_contact_info['custom_icon']); ?>"></i>
					                    <?php endif;?>
	                                </div>
	                                <div class="content">
	                                	<h5 class="title"><?php echo wp_kses($single_contact_info['title'], 'consua_allowed_tags'); ?></h5>
	                                  	<?php echo wp_kses($single_contact_info['info'], 'consua_allowed_tags'); ?>
	                                </div>
	                            </li>
                           <?php endforeach?>
                        </ul>
                    </div>
                </div>
                
                <div class="contact-stye-one col-lg-7 pl-60 pl-md-15 pl-xs-15 mt-md-50">
                    <div class="contact-form-style-one">
                       	<?php if(!empty($consua_contact_form_output['form_title'])):?>
	                        <h5 class="sub-title"><?php echo wp_kses($consua_contact_form_output['form_title'], 'consua_allowed_tags'); ?></h5>
	                    <?php endif;?>
	                    <?php if(!empty($consua_contact_form_output['form_subtitle'])):?>
                        	<h2 class="heading"><?php echo wp_kses($consua_contact_form_output['form_subtitle'], 'consua_allowed_tags'); ?></h2>
                        <?php endif;?>
                        <?php if(!empty($consua_contact_form_output['contact_shortcode'])):?>
                        	<?php echo do_shortcode($consua_contact_form_output['contact_shortcode']);?>
                        <?php endif;?>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Contact Style Two -->

	<?php elseif($consua_contact_form_output['style'] == '3'): ?>

    <!-- Start Estimate 
    ============================================= -->
    <div class="estimate-area bg-dark text-light default-padding">
        <div class="container">
            <div class="row">

                <div class="col-lg-6">
                    <div class="estimate-style-one">
                    	<?php if(!empty($consua_contact_form_output['section_subtitle'])):?>
                        	<h4 class="sub-title"><?php echo wp_kses($consua_contact_form_output['section_subtitle'], 'consua_allowed_tags'); ?></h4>
                        <?php endif ?>
                        <?php if(!empty($consua_contact_form_output['section_subtitle'])):?>
                        	<h2 class="title"><?php echo wp_kses($consua_contact_form_output['section_title'], 'consua_allowed_tags'); ?></h2>
						<?php endif ?>
                        
                        <div class="esitmate-form mt-40">
                            <?php if(!empty($consua_contact_form_output['contact_shortcode'])):?>
	                        	<?php echo do_shortcode($consua_contact_form_output['contact_shortcode']);?>
	                        <?php endif;?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-5 offset-lg-1">
                    <div class="estimate-thumb">
                    	<?php if(!empty($consua_contact_form_output['contact_image']['url'])):?>
                        	<img src="<?php echo esc_url($consua_contact_form_output['contact_image']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                    	<?php endif;?>
                    	<?php if(!empty($consua_contact_form_output['contact_shape']['url'])):?>
                        <div class="shape">
                            <img src="<?php echo esc_url($consua_contact_form_output['contact_shape']['url']);?>" alt="<?php echo esc_attr(get_bloginfo('name'));?>">
                        </div>
                        <?php endif;?>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Estimate -->

	<?php 
	endif;
	}
}