<?php
	/**
	* Elementor Faq Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Faq_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Faq widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_faq_widget';
	}

	/**
	* Get widget title.
	*
	* Retrieve Faq widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Faqs', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Faq widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Faq widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		
		$this->start_controls_section(
			'accordian_content',
			[
				'label'		=> esc_html__( 'Set Accordian Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
					'3'  	=> esc_html__( 'Style Three', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label' 		=> esc_html__( 'Section Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'Type Your Title Here', 'consua-core' ),
			]

		);

		$this->add_control(
			'subtitle',
			[
				'label' 		=> esc_html__( 'Section Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'Type Your Subtitle Here', 'consua-core' ),
				'condition' => [
                   'style' => ['1']
                ]
			]
		);

		$this->add_control(
			'menu_title',
			[
				'label' 		=> esc_html__( 'Left menu title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'Type Your Subtitle Here', 'consua-core' ),
				'condition' => [
                   'style' => ['3']
                ]
			]
		);

		$nav_menus = new \Elementor\Repeater();

		$nav_menus->add_control(
		    'nav_menu',
		    [
		        'label' => __('Select Nav Menu', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::SELECT2,
		        'options' => consua_get_nav_menu(),
		        'label_block' => true,
		    ]
		);


		$this->add_control(
		    'nav_menus',
		    [
		        'label' => __('Nav Menus', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::REPEATER,
		        'fields' => $nav_menus->get_controls(),
		        'prevent_empty' => false,
		        'condition' => [
                   'style' => ['3']
                ]
		    ]
		);	

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'heading', [
				'label' 		=> esc_html__( 'Heading', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> 2,
			]
		);

		$repeater->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> 3,
			]
		);

		$this->add_control(
			'accordian_list',
			[
				'label' 	=> esc_html__( 'Accordian', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Accordian', 'consua-core' ),
					],
				],
				'title_field' => '{{{ heading }}}',
			]
		);
		

		$this->add_control(
			'faq_front_image',
			[
				'label'			=> esc_html__( 'Front Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                   'style' => ['1']
                ]
			]
		);

		$this->add_control(
			'faq_bg_shape_image',
			[
				'label'			=> esc_html__( 'Background Shape Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                   'style' => ['1','3']
                ]
			]
		);

		$this->end_controls_section();

	}

	// Output For User
	protected function render(){
	$consua_faq_output = $this->get_settings_for_display();
	$accordian_lists = $consua_faq_output['accordian_list'];
	if($consua_faq_output['style'] == '1'):
	?>
    <!-- Start Faq 
    ============================================= -->
    <div class="faq-style-one-area relative" style="background-image: url(<?php echo esc_url($consua_faq_output['faq_bg_shape_image']['url']);?>);">

        
        <div class="container">
            <div class="row align-center">

                <div class="col-lg-6">
                    <div class="faq-style-one default-padding">
                    	<?php if(!empty($consua_faq_output['subtitle'])):?>
	                        <h4 class="sub-heading">
	                        	<?php echo htmlspecialchars_decode(esc_html($consua_faq_output['subtitle'],'consua-core')); ?>
	                        </h4>
                    	<?php endif;?>
                    	<?php if(!empty($consua_faq_output['title'])):?>
	                        <h2 class="title mb-30">
	                        	<?php echo htmlspecialchars_decode(esc_html($consua_faq_output['title'],'consua-core')); ?>
	                        </h2>
                        <?php endif;?>
                        <div class="accordion" id="faqAccordion">
                        	<?php
				        		$counter=1;
				        		foreach($accordian_lists as $single_accordian):
				        	?>
	                            <div class="accordion-item">
	                                <h2 class="accordion-header" id="heading<?php echo esc_attr($counter);?>">
	                                    <button class="accordion-button <?php if($counter == '1'){echo esc_attr__("");}else{echo esc_attr__("collapsed",'consua-core');}?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr($counter);?>" aria-expanded="true" aria-controls="collapse<?php echo esc_attr($counter);?>">
	                                         <?php echo htmlspecialchars_decode(esc_html($single_accordian['heading'],'consua-core')); ?>
	                                    </button>
	                                </h2>
	                                <div id="collapse<?php echo esc_attr($counter);?>" class="accordion-collapse collapse <?php if($counter == '1'){echo esc_attr__("show");}else{echo esc_attr__("",'consua-core');}?>" aria-labelledby="heading<?php echo esc_attr($counter);?>" data-bs-parent="#faqAccordion">
	                                    <div class="accordion-body">
	                                        <p>
	                                             <?php echo htmlspecialchars_decode(esc_html($single_accordian['content'],'crysa-core')); ?>
	                                        </p>
	                                    </div>
	                                </div>
	                            </div>
	                        <?php 
				            	$counter++;
								endforeach;
							?>    
                        </div>
                    </div>
                </div>

				<?php if(!empty($consua_faq_output['faq_front_image']['url'])):?>
	                <div class="col-lg-5 offset-lg-1 mt-120 mt-md-50 mt-xs-30">
	                    <div class="faq-thumb">
	                        <?php 
					        	echo consua_img_tag( array(
						            'url'   => esc_url( $consua_faq_output['faq_front_image']['url'] )
						    	) );
						    ?>
	                    </div>
	                </div>
            	<?php endif;?>
            </div>
        </div>
    </div>
    <!-- End Faq -->

    <?php elseif($consua_faq_output['style'] == '2'): ?>

    <div class="faq-style-one dark">
    	<?php if(!empty($consua_faq_output['title'])):?>
	        <h3 class="mb-30">
	        	<?php echo wp_kses_post($consua_faq_output['title'],'consua_kses_allowed_html');?>
	        </h3>
        <?php endif;?>
        <div class="accordion" id="faqAccordion">

        	<?php
        		$counter=1;
        		foreach($accordian_lists as $single_accordian):
        	?>
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading<?php echo esc_attr($counter);?>">
                    <button class="accordion-button <?php if($counter == '1'){echo esc_attr__("");}else{echo esc_attr__("collapsed",'consua-core');}?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr($counter);?>" aria-expanded="true" aria-controls="collapse<?php echo esc_attr($counter);?>">
                       <?php echo wp_kses_post($single_accordian['heading'],'consua_kses_allowed_html');?>
                    </button>
                </h2>
                <div id="collapse<?php echo esc_attr($counter);?>" class="accordion-collapse collapse <?php if($counter == '1'){echo esc_attr__("show");}else{echo esc_attr__("",'consua-core');}?>" aria-labelledby="collapse<?php echo esc_attr($counter);?>" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        <p>
                          	<?php echo wp_kses_post($single_accordian['content'],'consua_kses_allowed_html');?>
                        </p>
                    </div>
                </div>
            </div>
           	<?php 
            	$counter++;
				endforeach;
			?> 
        </div>
    </div>

	<?php elseif($consua_faq_output['style'] == '3'): ?>

	 <!-- Start Faq Area 
    ============================================= -->
    <div class="faq-area bg-gray default-padding">
        <!-- End Shape -->
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-md-30 mb-xs-30">
                    <div class="faq-sidebar">
                        <div class="faq-sidebar-item bg-theme text-light" style="background-image: url(<?php echo esc_url($consua_faq_output['faq_bg_shape_image']['url']);?>);">
                            <h4><?php echo wp_kses_post($consua_faq_output['menu_title'],'consua_kses_allowed_html');?></h4>
                            <?php
					    	foreach ($consua_faq_output['nav_menus'] as $faq_nav_menu) : ?>
					            <?php wp_nav_menu(array(
					                'menu' => $faq_nav_menu['nav_menu'],
					            ));
					            ?>
					        <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8 faq-style-one dark pl-50 pl-md-15 pl-xs-15">

                    <h2 class="title mb-40"><?php echo wp_kses_post($consua_faq_output['title'],'consua_kses_allowed_html');?></h2>
                    
                    <div class="accordion" id="faqAccordion">

			        	<?php
			        		$counter=1;
			        		foreach($accordian_lists as $single_accordian):
			        	?>
			            <div class="accordion-item">
			                <h2 class="accordion-header" id="heading<?php echo esc_attr($counter);?>">
			                    <button class="accordion-button <?php if($counter == '1'){echo esc_attr__("");}else{echo esc_attr__("collapsed",'consua-core');}?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr($counter);?>" aria-expanded="true" aria-controls="heading<?php echo esc_attr($counter);?>">
			                       <?php echo wp_kses_post($single_accordian['heading'],'consua_kses_allowed_html');?>
			                    </button>
			                </h2>
			                <div id="collapse<?php echo esc_attr($counter);?>" class="accordion-collapse collapse <?php if($counter == '1'){echo esc_attr__("show");}else{echo esc_attr__("",'consua-core');}?>" aria-labelledby="heading<?php echo esc_attr($counter);?>" data-bs-parent="#faqAccordion">
			                    <div class="accordion-body">
			                        <p>
			                          	<?php echo wp_kses_post($single_accordian['content'],'consua_kses_allowed_html');?>
			                        </p>
			                    </div>
			                </div>
			            </div>
			           	<?php 
			            	$counter++;
							endforeach;
						?> 
			        </div>

                </div>
            </div>
        </div>
    </div>
    <!-- End Faq Area -->

	<?php 
	endif;
	}
}