<?php
	/**
	* Elementor Funfactor Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Funfactor_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Funfactor widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_funfactor';
	}

	/**
	* Get widget title.
	*
	* Retrieve Funfactor widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Funfactor', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Funfactor widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Funfactor widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		

		$this->start_controls_section(
			'funfactor_content',
			[
				'label'		=> esc_html__( 'Set Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'number', [
				'label' 		=> esc_html__( 'Number', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'operator', [
				'label' 		=> esc_html__( 'Operator', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'funfact_list',
			[
				'label' 	=> esc_html__( 'Funfact List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Funfact', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'funfact_shape_divider',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'funfact_shape_one',
			[
				'label' 	=> esc_html__( 'Background Shape One', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => '1'
                ]
			]
		);
		$this->add_control(
			'funfact_shape_two',
			[
				'label' 	=> esc_html__( 'Background Shape Two', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => '1'
                ]
			]
		);
		
		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'funfact-style.php';	
	}

	// Output For User
	protected function render(){
	$consua_funfact_output = $this->get_settings_for_display();
	$funfact_list = $consua_funfact_output['funfact_list'];
	if($consua_funfact_output['style'] == '1'):
	?>
    <!-- Start Fun Factor Area One
    ============================================= -->
    <div class="fun-factor-style-one-area bg-gray default-padding" style="background-image: url(<?php echo esc_url($consua_funfact_output['funfact_shape_one']['url']);?>);">
        <div class="container">
            <div class="fun-factor-style-one-box">

            	<?php if(!empty($consua_funfact_output['funfact_shape_two']['url'])):?>
	                <div class="shape-animated-up-down">
	                    <img src="<?php echo esc_url($consua_funfact_output['funfact_shape_two']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                </div>
            	<?php endif;?>

                <div class="row align-center">
                    
                    <div class="col-lg-10 offset-lg-1 text-center fun-fact-style-one">
                        <div class="row">
                        <?php 
	                    	foreach ($funfact_list as $single_funfact):
	                    ?>   
                            <!-- Single item -->
                            <div class="col-lg-4 col-md-4 item">
                                <div class="fun-fact">
                                    <div class="counter">
                                        <div class="timer" data-to="<?php echo esc_attr($single_funfact['number']);?>" data-speed="2000"><?php echo esc_html($single_funfact['number']);?></div>
                                        <div class="operator"><?php echo wp_kses_post($single_funfact['operator'],'consua_kses_allowed_html');?></div>
                                    </div>
                                    <span class="medium"><?php echo wp_kses_post($single_funfact['title'],'consua_kses_allowed_html');?></span>
                                </div>
                            </div>
                            <!-- End Single item -->
                        <?php
	                	    endforeach;
	                	?>    
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- End Fun Factor Area One -->

	<?php elseif($consua_funfact_output['style'] == '2'):?>

	<!-- Start Fun Factor Area Two
    ============================================= -->
    <div class="fun-factor-style-two-area">
        <div class="container">
            <div class="fun-factor-style-two-box">
                <div class="row align-center">

            	  	<?php 
                    	foreach ($funfact_list as $single_funfact):
                    ?> 
	                    <!-- Single item -->
	                    <div class="col-xl-4 col-md-4 item">
	                        <div class="fun-fact">
	                            <div class="counter">
	                                <div class="timer" data-to="<?php echo esc_attr($single_funfact['number']);?>" data-speed="2000"><?php echo esc_html($single_funfact['number']);?></div>
	                                <div class="operator"><?php echo esc_html($single_funfact['operator']);?></div>
	                            </div>
	                            <span class="medium"><?php echo esc_html($single_funfact['title']);?></span>
	                        </div>
	                    </div>
	                    <!-- End Single item -->
                   <?php
                	    endforeach;
                	?> 
                </div>
            </div>
        </div>
    </div>
    <!-- End Fun Factor Area Two -->
    	
	<?php 
	endif;
	}
}