<?php
	/**
	* Elementor Consua Marketing Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Marketing_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Marketing widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_marketing';
	}

	/**
	* Get widget title.
	*
	* Retrieve Marketing Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Marketing Types', 'Consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Marketing Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Marketing Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){
		$this->start_controls_section(
			'marketing_content_style',
			[
				'label'		=> esc_html__( 'Content Style','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' )
				],
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> esc_html__( 'Section Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Title', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		

		$feature_list = new \Elementor\Repeater();

		$feature_list->add_control(
			'title', [
				'label' 		=> esc_html__( 'Tab Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Tab Title', 'consua-core' ),
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'feature_list',
			[
				'label' 	=> esc_html__( 'Feature List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $feature_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$social = new \Elementor\Repeater();

		$social->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$social->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$social->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$social->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$social->add_control(
		    'url',
		    [
		        'label' => __('Add Url', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::URL,
		        'placeholder' => __('#', 'apsro-addon'),
		        'show_external' => false,
		        'default' => [
		            'url' => '#',
		            'is_external' => false,
		            'nofollow' => false,
		        ],
		        'show_label' => false,
		    ]
		);

		$this->add_control(
		    'social_list',
		    [
		        'label' => __('Social List', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::REPEATER,
		        'fields' => $social->get_controls(),
		        'prevent_empty' => false,
		        'default' => [
		            [
		                'social_url' => [
		                    'url' => '#',
		                    'is_external' => false,
		                    'nofollow' => false,
		                ],
		            ],
		        ],
		    ]
		);


		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'marketing-style.php';	
	}

	// Output For User
	protected function render(){	
	$consua_marketing_output = $this->get_settings_for_display();
	if($consua_marketing_output['style'] == '1'):
	?>

    <!-- Start Marketing Types
    ============================================= -->
    <div class="marketing-types-area text-center default-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="marketing-types">
                        <div class="content">
                            <h2><?php echo wp_kses($consua_marketing_output['section_title'], 'consua_allowed_tags'); ?></h2>
                            <?php if(!empty($consua_marketing_output['feature_list'])):?>
	                            <ul class="types-list">
	                            	<?php 
						            	foreach ($consua_marketing_output['feature_list'] as $single_item):
						            ?>
	                                	<li><?php echo wp_kses($single_item['title'], 'consua_allowed_tags'); ?></li>
	                               	<?php endforeach;?>
	                            </ul>
                        	<?php endif;?>
                        </div>

                        <?php if(!empty($consua_marketing_output['social_list'] )):?>
	                        <div class="icon">
	                        	<?php 
					            	foreach ($consua_marketing_output['social_list'] as $single_item):
					            ?>
	             					<?php if(!empty($single_item['flat_icon'])):?>
				                    <i class="<?php echo esc_attr($single_item['flat_icon']); ?>"></i>
				                    <?php endif;?>
				                    <?php if(!empty($single_item['icon_image']['url'])):?>
				                        <img src="<?php echo esc_url($single_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
				                    <?php endif;?>
				                    <?php 
				                    	if(!empty($single_item['custom_icon'])):?>
				                        <i class="<?php echo esc_attr($single_item['custom_icon']); ?>"></i>
				                    <?php endif;?>
	                         	<?php endforeach;?>
	                        </div>
                    	<?php endif;?>

                        <div class="blur-shape"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- End Software Marketing -->

    <?php
	endif;
    }
}