<?php
	/**
	* Elementor Faq Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Mission_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Faq widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_mission_widget';
	}

	/**
	* Get widget title.
	*
	* Retrieve Faq widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Mission', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Faq widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Faq widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		
		$this->start_controls_section(
			'mission_content',
			[
				'label'		=> esc_html__( 'Set Accordian Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'heading', [
				'label' 		=> esc_html__( 'Heading', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> 1,
			]
		);

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> 2,
			]
		);

		$repeater->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> 2,
			]
		);

		$repeater->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::CODE,
				'label_block' 	=> true,
				'rows' 			=> 3,
			]
		);

		$this->add_control(
			'tab_list',
			[
				'label' 	=> esc_html__( 'Tab List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Tab', 'consua-core' ),
					],
				],
				'prevent_empty' => false,
				'title_field' => '{{{ heading }}}',
			]
		);
		

		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'heading', [
				'label' 		=> esc_html__( 'Heading', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> 2,
			]
		);

		$repeater->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows' 			=> 3,
			]
		);

		$this->add_control(
			'accordian_list',
			[
				'label' 	=> esc_html__( 'Accordian', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Accordian', 'consua-core' ),
					],
				],
				'title_field' => '{{{ heading }}}',
			]
		);
		

		$this->add_control(
			'faq_bg_image',
			[
				'label'			=> esc_html__( 'Background Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'faq_bg_shape_image',
			[
				'label'			=> esc_html__( 'Shape Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'mission-style.php';

	}

	// Output For User
	protected function render(){
	$consua_mission_output = $this->get_settings_for_display();
	$accordian_list = $consua_mission_output['accordian_list'];
	$tab_list = $consua_mission_output['tab_list'];
	?>
    <!-- Start Mission & Vision 
    ============================================= -->
    <div class="mission-vision-style-one-area overflow-hidden default-padding" style="background-image: url(<?php echo esc_url($consua_mission_output['faq_bg_image']['url']);?>);">

    	<?php if(!empty($consua_mission_output['faq_bg_shape_image']['url'])):?>
	        <div class="shape-top-left">
	            <?php 
		        	echo consua_img_tag( array(
			            'url'   => esc_url( $consua_mission_output['faq_bg_shape_image']['url'] )
			    	) );
			    ?>
	        </div>
		<?php endif;?>

        <div class="container">
            <div class="row">

                <div class="col-lg-6">

                    <div class="nav nav-tabs mission-tab-navs" id="nav-tab" role="tablist">
                    	<?php
			        		$counter=1;
			        		foreach($tab_list as $single_tab):
			        	?>
	                        <button class="nav-link <?php if($counter == '1'){echo esc_attr__("active");} ?>" id="nav-id-<?php echo esc_attr($counter);?>" data-bs-toggle="tab" data-bs-target="#tab<?php echo esc_attr($counter);?>" type="button" role="tab" aria-controls="tab<?php echo esc_attr($counter);?>" aria-selected="true">
	                           <?php echo wp_kses($single_tab['heading'], 'consua_allowed_tags'); ?>
	                        </button>
                       	<?php 
			            	$counter++;
							endforeach;
						?>
                    </div>

                    <div class="tab-content mission-tab-content" id="nav-tabContent">
                    	<?php
			        		$counter=1;
			        		foreach($tab_list as $single_tab):
			        	?>
	                        <!-- Tab Single Item -->
	                        <div class="tab-pane fade <?php if($counter == '1'){echo esc_attr__("show active");}else{echo esc_attr__("collapse",'consua-core');}?>" id="tab<?php echo esc_attr($counter);?>" role="tabpanel" aria-labelledby="nav-id-<?php echo esc_attr($counter);?>">
	                            <h2><?php echo wp_kses($single_tab['title'], 'consua_allowed_tags'); ?></h2>
	                            <p>
	                               <?php echo wp_kses($single_tab['subtitle'], 'consua_allowed_tags'); ?>
	                            </p>
	                            <?php echo wp_kses($single_tab['content'], 'consua_allowed_tags'); ?>
	                        </div>
	                        <!-- End Tab Single Item -->
                        <?php 
			            	$counter++;
							endforeach;
						?>
                    </div>


                </div>

                <div class="col-lg-5 offset-lg-1 mt-md-50 mt-xs-40">
                    <div class="faq-style-one secondary">
                        <div class="accordion" id="faqAccordion">
                        	<?php
				        		$counter=1;
				        		foreach($accordian_list as $single_accordian):
				        	?>
	                            <div class="accordion-item">
	                                <h2 class="accordion-header" id="heading<?php echo esc_attr($counter);?>">
	                                    <button class="accordion-button <?php if($counter == '1'){echo esc_attr__("");}else{echo esc_attr__("collapsed",'consua-core');}?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr($counter);?>" aria-expanded="true" aria-controls="collapse<?php echo esc_attr($counter);?>">
	                                        <?php echo htmlspecialchars_decode(esc_html($single_accordian['heading'],'consua-core')); ?>
	                                    </button>
	                                </h2>
	                                <div id="collapse<?php echo esc_attr($counter);?>" class="accordion-collapse <?php if($counter == '1'){echo esc_attr__("show");}else{echo esc_attr__("collapse",'consua-core');}?>" aria-labelledby="collapse<?php echo esc_attr($counter);?>" data-bs-parent="#faqAccordion">
	                                    <div class="accordion-body">
	                                        <p>
	                                            <?php echo htmlspecialchars_decode(esc_html($single_accordian['content'],'consua-core')); ?>
	                                        </p>
	                                    </div>
	                                </div>
	                            </div>
                            <?php 
				            	$counter++;
								endforeach;
							?> 
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
    <!-- End Mission & Vision  -->
	<?php 
	}
}