<?php
	/**
	* Elementor Consua Overview Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Overview_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Overview widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_overview';
	}

	/**
	* Get widget title.
	*
	* Retrieve Overview Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Overview', 'Consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Overview Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Overview Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){
		$this->start_controls_section(
			'Overview_content_style',
			[
				'label'		=> esc_html__( 'Content Style','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' )
				],
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> esc_html__( 'Section Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Title', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> esc_html__( 'Section Sub-Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section sub title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Sub Title', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$overview_style_one = new \Elementor\Repeater();

		$overview_style_one->add_control(
			'tab_title', [
				'label' 		=> esc_html__( 'Tab Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Tab Title', 'consua-core' ),
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		$overview_style_one->add_control(
			'content_title', [
				'label' 		=> esc_html__( 'Content Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'content title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Content Title', 'consua-core' ),
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		$overview_style_one->add_control(
			'summary', [
				'label' 		=> esc_html__( 'Summary', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'summary', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Summary', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$overview_style_one->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Add Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 	=> [
					'url' 		=> \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$overview_style_one->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$overview_style_one->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$overview_style_one->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$overview_style_one->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$overview_style_one->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$overview_style_one->add_control(
		    'active_status',
		    [
		        'label' => __('Is active?', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::SWITCHER,
		        'label_on' => __('Yes', 'apsro-addon'),
		        'label_off' => __('No', 'apsro-addon'),
		        'return_value' => 'yes',
		        'default' => 'no',
		    ]
		);
		
		$this->add_control(
			'overview_list',
			[
				'label' 	=> esc_html__( 'Overview List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $overview_style_one->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ tab_title }}}',
			]
		);

		
		$this->add_control(
			'overview_bac_shape',
			[
				'label'			=> esc_html__( 'Bacground Shape','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'overview-style.php';	
	}

	// Output For User
	protected function render(){	
	$consua_overview_output = $this->get_settings_for_display();
	if($consua_overview_output['style'] == '1'):
	?>

    <!-- Start Software Overview 
    ============================================= -->
    <div class="software-overview-area default-padding bg-dark secondary text-light bg-cover" style="background-image: url(<?php echo esc_url($consua_overview_output['overview_bac_shape']['url']); ?>);">

    	<?php if(!empty($consua_overview_output['section_title'] || $consua_overview_output['section_subtitle'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center secondary">
	                    	<?php if(!empty($consua_overview_output['section_subtitle'])):?>
	                       		<h4 class="sub-heading"><?php echo wp_kses($consua_overview_output['section_subtitle'], 'consua_allowed_tags'); ?></h4>
	                       	<?php endif;?>
	                       	<?php if(!empty($consua_overview_output['section_title'])):?>
	                        <h2 class="title"><?php echo wp_kses($consua_overview_output['section_title'], 'consua_allowed_tags'); ?></h2>
	                    	<?php endif;?>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>


        <div class="container">
            <div class="row">
                <div class="col-lg-4 pr-50 pr-md-15 pr-xs-15">

                    <div class="nav nav-tabs software-tab-navs" id="nav-tab" role="tablist">
                       
                        <?php
                    	if (!empty($consua_overview_output['overview_list'])) : 
        				$i = 1;
	                	foreach($consua_overview_output['overview_list'] as $overview_item):?>
	                        <button class="nav-link <?php echo esc_attr(('yes' == $overview_item['active_status'] ? 'active' : '')); ?>" id="nav-id-<?php echo esc_attr($i);?>" data-bs-toggle="tab" data-bs-target="#tab<?php echo esc_attr($i);?>" type="button" role="tab" aria-controls="tab<?php echo esc_attr($i);?>" aria-selected="false">
	                            <?php echo wp_kses($overview_item['tab_title'], 'consua_allowed_tags'); ?>
	                            <span><?php echo esc_html("0"); ?><?php echo esc_html($i);?></span>
	                        </button>
	                    <?php 
		               		$i++; 
		                	endforeach; endif;
		                ?>
                       
                    </div>
                </div>


                <div class="col-lg-8">
                    <div class="tab-content software-tab-content" id="nav-tabContent">

                    <?php
                    	if (!empty($consua_overview_output['overview_list'])) : 
        				$i = 1;
	                	foreach($consua_overview_output['overview_list'] as $overview_item):?>
	                        <!-- Tab Single Item -->
	                        <div class="tab-pane fade  <?php echo esc_attr(('yes' == $overview_item['active_status'] ? 'show active' : '')); ?>" id="tab<?php echo esc_attr($i); ?>" role="tabpanel" aria-labelledby="nav-id-<?php echo esc_attr($i)?>">
	                            <div class="soft-overview">
	                                <img src="<?php echo esc_url($overview_item['image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                                <div class="overlay">
	                                    <h3><?php echo wp_kses($overview_item['content_title'], 'consua_allowed_tags'); ?></h3>
	                                    <p>
	                                       <?php echo wp_kses($overview_item['summary'], 'consua_allowed_tags'); ?>
	                                    </p>
	                                    <?php if(!empty($overview_item['url']['url'])):?>
		                                    <a href="<?php echo esc_url($overview_item['url']['url']);?>">
			                                    <?php if(!empty($overview_item['flat_icon'])):?>
								                        <i class="<?php echo esc_attr($overview_item['flat_icon']); ?>"></i>
									                    <?php endif;?>
								                    <?php if(!empty($overview_item['icon_image'])):?>
								                        <img src="<?php echo esc_url($overview_item['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
								                    <?php endif;?>
								                    <?php 
								                    	if(!empty($overview_item['custom_icon'])):?>
								                        <i class="<?php echo esc_attr($overview_item['custom_icon']); ?>"></i>
							                    <?php endif;?>
		                                    </a>
	                                	<?php endif;?>
	                                </div>
	                            </div>
	                        </div>
	                        <!-- End Tab Single Item -->
	               	<?php 
	               		$i++; 
	                	endforeach; endif;
	                ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Software Overview -->

    <?php
	endif;
    }
}