<?php
	/**
	* Elementor Consua Partner Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Partner_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Consua Partner widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_partner';
	}

	/**
	* Get widget title.
	*
	* Retrieve Consua Partner widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Consua Partner', 'Consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Consua Brand widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Consua Partner widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'consua_partner_content',
			[
				'label'		=> esc_html__( 'Set Partner Content','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'partner_title', [
				'label' 		=> esc_html__( 'Partner Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'          => '2', 
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'partner_year', [
				'label' 		=> esc_html__( 'Partner Year', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'year', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Year', 'consua-core' ),
				'condition' => [
                    'style' => '1'
                ]
			]
		);

		$this->add_control(
			'partner_bg_image',
			[
				'label'			=> esc_html__( 'Partner Background Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'partner_mask_bg_image',
			[
				'label'			=> esc_html__( 'Mask Background Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => '1'
                ]
			]
		);
		

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'brand_image',
			[
				'label'			=> esc_html__( 'Add Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'brand_image_list',
			[
				'label' 	=> esc_html__( 'Partner List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'prevent_empty' => 'false',
			]
		);
		
		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'partner-style.php';
	}

	// Output For User
	protected function render(){
	$consua_partner_content = $this->get_settings_for_display();
	$consua_brand_list = $consua_partner_content['brand_image_list'];
	if($consua_partner_content['style'] == '1'):
	?>
    <!-- Start Partner Area  
    ============================================= -->
	    <div class="partner-style-one-area">
	        <div class="container">
	            <div class="row align-center">
	                <div class="col-lg-5">
	                    <div class="partner-map" style="background-image: url(<?php echo esc_url($consua_partner_content['partner_bg_image']['url']); ?>);">
	                        <h2 class="mask-text" style="background-image: url(<?php echo esc_url($consua_partner_content['partner_mask_bg_image']['url']); ?>);"><?php echo esc_html($consua_partner_content['partner_year']);?></h2>
	                        <?php if(!empty($consua_partner_content['partner_title'])):?>
	                        	<h4><?php echo esc_html($consua_partner_content['partner_title']);?></h4>
	                    	<?php endif;?>
	                    </div>
	                </div>
	                <div class="col-lg-6 offset-lg-1">
	                    <div class="partner-items">
	                        <ul>
								<?php foreach($consua_brand_list as $single_brand):
	                        		if(!empty($single_brand['brand_image']['url'])):
	                        	?>
		                            <li>
		                            	<img src="<?php echo esc_url($single_brand['brand_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                            </li>
	                            <?php endif; endforeach;?>
	                        </ul>
	                    </div>
	                </div>
	            </div>
	        </div>
	    </div>
    <!-- End Partner Area -->
	<?php elseif($consua_partner_content['style'] == '2'):?>

	<!-- Start Partner Style Two
    ============================================= -->
    <div class="partner-style-two-area overflow-hidden bg-gradient-secondary text-light default-padding">
    	<?php if(!empty($consua_partner_content['partner_bg_image']['url'])):?>
        	<div class="partner-shape" style="background-image: url(<?php echo esc_url($consua_partner_content['partner_bg_image']['url']); ?>);"></div>
    	<?php endif;?>
        <div class="container">
            <div class="row align-center">
            	<?php if(!empty($consua_partner_content['partner_title'])):?>
	                <div class="col-lg-4">
	                    <div class="partner-heading">
	                        <h3><?php echo wp_kses_post($consua_partner_content['partner_title'],'consua_kses_allowed_html');?></h3>
	                    </div>
	                </div>
                <?php endif;?>
                <div class="col-lg-7 offset-lg-1">

                    <div class="clients-style-two-carousel swiper">
                        <!-- Additional required wrapper -->
                        <div class="swiper-wrapper">
                        	<?php foreach($consua_brand_list as $single_brand):
	                        	?>
                            <!-- Single Item -->
	                            <div class="swiper-slide">
	                                <img src="<?php echo esc_url($single_brand['brand_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                            </div>
                            <!-- End Single Item -->
                            <?php  endforeach;?>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- End Partner Style Two-->

	<?php
	endif;
	}
}