<?php
	/**
	* Elementor Consua pricing Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Pricing_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve pricing widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_pricing';
	}

	/**
	* Get widget title.
	*
	* Retrieve pricing Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'pricing', 'Consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve pricing Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the pricing Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){
		$this->start_controls_section(
			'pricing_content_style',
			[
				'label'		=> esc_html__( 'Content Style','Consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'section_title', [
				'label' 		=> esc_html__( 'Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Title', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'section_subtitle', [
				'label' 		=> esc_html__( 'Sub-Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section SubTitle', 'consua-core' ),
				'rows'   		=>'4',
				'label_block' 	=> true,
			]
		);

		$pricnig_one = new \Elementor\Repeater();

		$pricnig_one->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'rows'   		=>'1',
				'label_block' 	=> true,
			]
		);

		$pricnig_one->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'rows'   		=>'2',
				'label_block' 	=> true,
			]
		);

		$pricnig_one->add_control(
			'price', [
				'label' 		=> esc_html__( 'Price', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'price', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Price', 'consua-core' ),
				'rows'   		=>'1',
				'label_block' 	=> true,
			]
		);

		$pricnig_one->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::CODE,
				'placeholder' 	=> esc_html__( 'content', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Content', 'consua-core' ),
				'rows'   		=>'1',
				'label_block' 	=> true,
			]
		);

		$pricnig_one->add_control(
			'shape',
			[
				'label'			=> esc_html__( 'Add Shape','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$pricnig_one->add_control(
			'button_label',
			[
				'label' 	=> __( 'Button Label', 'consua' ),
                'type' 		=> \Elementor\Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Button Label', 'consua' )
			]
        );

        $pricnig_one->add_control(
			'button_link',
			[
				'label' 		=> __( 'URL', 'consua' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$pricnig_one->add_control(
		    'active_status',
		    [
		        'label' => __('Is active?', 'apsro-addon'),
		        'type' => \Elementor\Controls_Manager::SWITCHER,
		        'label_on' => __('Yes', 'apsro-addon'),
		        'label_off' => __('No', 'apsro-addon'),
		        'return_value' => 'yes',
		        'default' => 'no',
		    ]
		);
		
		$this->add_control(
			'pricing_list',
			[
				'label' 	=> esc_html__( 'Pricing List', 'Consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $pricnig_one->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);


		$this->add_control(
			'pricing_bac_shape',
			[
				'label'			=> esc_html__( 'Active Shape','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['1','2']
                ]
			]
		);

		$this->add_control(
			'pricing_active_text',
			[
				'label'			=> esc_html__( 'Active Text','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'condition' => [
                    'style' => ['1','2']
                ]
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'pricing-style.php';	
	}

	// Output For User
	protected function render(){	
	$consua_pricing_output = $this->get_settings_for_display();
	if($consua_pricing_output['style'] == '1'):
	?>

    <!-- Start Pricing 
    ============================================= -->
    <div class="pricing-style-one-area secondary">
    	<?php if(!empty($consua_pricing_output['section_title'] || $consua_pricing_output['section_subtitle'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading secondary text-center">
	                       	<h4 class="sub-heading"><?php echo wp_kses($consua_pricing_output['section_subtitle'], 'consua_allowed_tags'); ?></h4>
	                        <h2 class="title"><?php echo wp_kses($consua_pricing_output['section_title'], 'consua_allowed_tags'); ?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">
				<?php
					if (!empty($consua_pricing_output['pricing_list'])) : 
	        		$i = 1;
	                foreach($consua_pricing_output['pricing_list'] as $pricing_item):?>

	                <!-- Single Itme -->
	                <div class="col-xl-3 col-md-6 mb-30">
	                    <div class="pricing-style-one<?php  if('yes' == $pricing_item['active_status']):echo esc_attr(" active");endif;?>" style="background-image: url(<?php echo esc_url($pricing_item['shape']['url']); ?>);">
	                    	<?php if('yes' == $pricing_item['active_status']):?>
		                        <div class="pricing-badge">
		                           <?php if($consua_pricing_output['pricing_active_text']):?>
		                            	<h5><?php echo wp_kses($consua_pricing_output['pricing_active_text'], 'consua_allowed_tags'); ?></h5>
		                        	<?php endif;?>
		                            <?php if(!empty($consua_pricing_output['pricing_bac_shape']['url'])):?>
		                            	<img src="<?php echo esc_url($consua_pricing_output['pricing_bac_shape']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                        	<?php endif;?>
		                        </div>
	                    	<?php endif;?>
	                        <div class="pricing-header">
	                            <h4><?php echo wp_kses($pricing_item['title'], 'consua_allowed_tags'); ?></h4>
	                            <p>
	                               <?php echo wp_kses($pricing_item['subtitle'], 'consua_allowed_tags'); ?>
	                            </p>
	                        </div>
	                        <div class="pricing-content">
	                            <div class="price">
	                                <h2><?php echo wp_kses($pricing_item['price'], 'consua_allowed_tags'); ?></h2>
	                            </div>
	                            <?php echo wp_kses($pricing_item['content'], 'consua_allowed_tags'); ?>
	                            <?php if(!empty($pricing_item['button_link']['url'])):?>
	                            	<a class="btn mt-25 btn-sm <?php  if('yes' == $pricing_item['active_status']):echo esc_attr("btn-theme secondary");else: echo esc_attr("btn-dark");endif;?> animation" href="<?php echo esc_url($pricing_item['button_link']['url']);?>"><?php echo wp_kses($pricing_item['button_label'], 'consua_allowed_tags'); ?></a>
	                        	<?php endif;?>
	                        </div>
	                    </div>
	                </div>
	                <!-- End Single Itme -->
	            <?php $i++; endforeach; endif;?>
            </div>
        </div>
    </div>
    <!-- End Pricng -->

	<?php elseif($consua_pricing_output['style'] == '2'): ?>

	 <!-- Start Pricing 
    ============================================= -->
    <div class="pricing-style-one-area">
    	<?php if(!empty($consua_pricing_output['section_title'] || $consua_pricing_output['section_subtitle'])):?>
	    	<div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                    	<h4 class="sub-heading"><?php echo wp_kses($consua_pricing_output['section_subtitle'], 'consua_allowed_tags'); ?></h4>
	                        <h2 class="title"><?php echo wp_kses($consua_pricing_output['section_title'], 'consua_allowed_tags'); ?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
        <?php endif;?>
        <div class="container">
            <div class="row">
                <?php
					if (!empty($consua_pricing_output['pricing_list'])) : 
	        		$i = 1;
	                foreach($consua_pricing_output['pricing_list'] as $pricing_item):?>

	                <!-- Single Itme -->
	                <div class="col-xl-3 col-md-6 mb-30">
	                    <div class="pricing-style-one<?php  if('yes' == $pricing_item['active_status']):echo esc_attr(" active");endif;?>" style="background-image: url(<?php echo esc_url($pricing_item['shape']['url']); ?>);">
	                    	<?php if('yes' == $pricing_item['active_status']):?>
		                        <div class="pricing-badge">
		                        	<?php if($consua_pricing_output['pricing_active_text']):?>
		                            	<h5><?php echo wp_kses($consua_pricing_output['pricing_active_text'], 'consua_allowed_tags'); ?></h5>
		                        	<?php endif;?>
		                            <?php if(!empty($consua_pricing_output['pricing_bac_shape']['url'])):?>
		                            	<img src="<?php echo esc_url($consua_pricing_output['pricing_bac_shape']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
		                        	<?php endif;?>
		                        </div>
	                    	<?php endif;?>
	                        <div class="pricing-header">
	                            <h4><?php echo wp_kses($pricing_item['title'], 'consua_allowed_tags'); ?></h4>
	                            <p>
	                               <?php echo wp_kses($pricing_item['subtitle'], 'consua_allowed_tags'); ?>
	                            </p>
	                        </div>
	                        <div class="pricing-content">
	                            <div class="price">
	                                <h2><?php echo wp_kses($pricing_item['price'], 'consua_allowed_tags'); ?></h2>
	                            </div>
	                            <?php echo wp_kses($pricing_item['content'], 'consua_allowed_tags'); ?>
	                            <?php if(!empty($pricing_item['button_link']['url'])):?>
	                            	<a class="btn mt-25 btn-sm <?php  if('yes' == $pricing_item['active_status']):echo esc_attr("btn-theme");else: echo esc_attr("btn-dark");endif;?> animation" href="<?php echo esc_url($pricing_item['button_link']['url']);?>"><?php echo wp_kses($pricing_item['button_label'], 'consua_allowed_tags'); ?></a>
	                        	<?php endif;?>
	                        </div>
	                    </div>
	                </div>
	                <!-- End Single Itme -->
	            <?php $i++; endforeach; endif;?>

            </div>
        </div>
    </div>
    <!-- End Pricng -->

    <?php
	endif;
    }
}