<?php
	/**
	* Elementor Consua Project Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Project_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Project widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_project';
	}

	/**
	* Get widget title.
	*
	* Retrieve Project Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Project', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Project Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Project Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'consua_project_style',
			[
				'label'		=> esc_html__( 'Project Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 		=> __( 'Style', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'consua-core' ),
					'2' 		=> __( 'Style Two', 'consua-core' ),
					'3' 		=> __( 'Style Three', 'consua-core' ),
					'4' 		=> __( 'Style Four', 'consua-core' ),
					'5' 		=> __( 'Style Five', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'          => '2',
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'          => '2',
				'placeholder' 	=> esc_html__( 'SubTitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'2',
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'1',
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default subitle', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'summary', [
				'label' 		=> esc_html__( 'Summary', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'summary', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Summary', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'button_label', [
				'label' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'rows' 			=>'2',
				'placeholder' 	=> esc_html__( 'button label', 'consua-core' ),
				'default' 		=> esc_html__( 'Button Label', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'project_url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'project_list',
			[
				'label' 	=> esc_html__( 'Project List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Project', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition'		=> [ 'style'	=>	'1' ],
				'prevent_empty' => false
			]
		);


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'2',
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'tagline', [
				'label' 		=> esc_html__( 'Tagline', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'1',
				'placeholder' 	=> esc_html__( 'tagline', 'consua-core' ),
				'default' 		=> esc_html__( 'Default tagline', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'shape',
			[
				'label'			=> esc_html__( 'Shape','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'project_url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'project_list_two',
			[
				'label' 	=> esc_html__( 'Project List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Project', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition'		=> [ 'style'	=>	'2' ],
				'prevent_empty' => false
			]
		);


		$project_four = new \Elementor\Repeater();

		$project_four->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'2',
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);
		$project_four->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'rows' 			=>'1', 	
				'label_block' 	=> true,
			]
		);

		$project_four->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);


		$project_four->add_control(
			'project_url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'project_list_four',
			[
				'label' 	=> esc_html__( 'Project List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $project_four->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Project', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition'		=> [ 'style'	=>	'4' ],
				'prevent_empty' => false
			]
		);

		$project_list_five = new \Elementor\Repeater();

		$project_list_five->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'2',
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);
		$project_list_five->add_control(
			'tagline', [
				'label' 		=> esc_html__( 'Tagline', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'1',
				'placeholder' 	=> esc_html__( 'tagline', 'consua-core' ),
				'default' 		=> esc_html__( 'Default tagline', 'consua-core' ), 	
				'label_block' 	=> true,
			]
		);

		$project_list_five->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$project_list_five->add_control(
			'project_url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'project_list_five',
			[
				'label' 	=> esc_html__( 'Project List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $project_list_five->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Project', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition'		=> [ 'style'	=>	'5' ],
				'prevent_empty' => false
			]
		);

		$this->add_control(
			'style_two_load_more_txt', [
				'label' 		=> esc_html__( 'Load More Text', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows' 			=>'3', 	
				'label_block' 	=> true,
				'condition'		=> [ 'style'	=>	['2','5'] ],
			]
		);

		$this->add_control(
			'nav_show',
			[
				'label' => __( 'Show/Hide Nav Icon', 'cleanu-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'cleanu-core' ),
				'label_off' => __( 'Hide', 'cleanu-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
                    'style' => ['4']
                ]
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'project-style.php';	
	}

	// Output For User
	protected function render(){	
	$consua_project_output = $this->get_settings_for_display();
	if($consua_project_output['style'] == '1'): 
	?>
    <!-- Start Project Style One
    ============================================= -->
    <div class="project-style-one-area default-padding bg-dark bottom-shape-light">
        <div class="container">
            <div class="heading-left text-light">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="content-left">
                            <h5 class="sub-heading"><?php echo htmlspecialchars_decode(esc_html($consua_project_output['subtitle'],'consua-core')); ?></h5>
                            <h2 class="heading"><?php echo htmlspecialchars_decode(esc_html($consua_project_output['title'],'consua-core')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Slider main container -->
                    <div class="project-style-one-carousel swiper">
                        <!-- Additional required wrapper -->
                        <div class="swiper-wrapper">

						<?php foreach($consua_project_output['project_list'] as $single_project): ?>
                            <!-- Single Item -->
                            <div class="swiper-slide">
                                <div class="project-style-one">
                                    <div class="row align-bottom">
                                    	<?php if(!empty($single_project['image']['url'])):?>
	                                        <div class="col-lg-7 pr-0 pr-md-15 pr-xs-15 pl-md-15 pl-xs-15">
	                                            <div class="thumb">
	                                                <img src="<?php echo esc_url($single_project['image']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
	                                            </div>
	                                        </div>
                                    	<?php endif;?>
                                        <div class="col-lg-5 pl-0 pl-md-15 pl-xs-15 pr-md-15 pr-xs-15">
                                            <div class="info">
                                            	<?php if(!empty($single_project['subtitle'])):?>
                                                	<span><?php echo esc_html($single_project['subtitle']);?></span>
                                                <?php endif;?>
                                                <?php if(!empty($single_project['title'])):?>
	                                                <h3>
	                                                	<a href="<?php echo esc_url($single_project['project_url']['url']); ?>"><?php echo esc_html($single_project['title']);?>
	                                                	</a>
	                                                </h3>
                                            	<?php endif;?>
                                                <?php if(!empty($single_project['summary'])):?>
	                                                <p>
	                                                    <?php echo esc_html($single_project['summary']);?>
	                                                </p>
                                            	<?php endif?>
                                            	<?php if(!empty($single_project['button_label'])):?>
                                                <a class="btn-animation dark mt-10" href="<?php echo esc_url($single_project['project_url']['url']); ?>"><i class="fas fa-arrow-right"></i> <span><?php echo esc_html($single_project['button_label']); ?></span></a>
                                            	<?php endif;?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Single Item -->
						<?php endforeach;?>
                        

                        </div>

                        <!-- Navigation -->
                        <div class="project-swiper-nav">

                            <!-- Pagination -->
                            <div class="project-pagination"></div>

                            <div class="project-button-prev"></div>
                            <div class="project-button-next"></div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Project Style One -->

    <?php elseif($consua_project_output['style'] == '2'): ?>

    <!-- Start Project Style Two
    ============================================= -->
    <div class="project-style-two-area bg-gray default-padding">
    	<?php if(!empty($consua_project_output['title'] || $consua_project_output['subtitle'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                        <?php if(!empty($consua_project_output['subtitle'])):?>
	                        	<h4 class="sub-heading"><?php echo wp_kses_post($consua_project_output['subtitle'],'consua_kses_allowed_html');?></h4>
	                    	<?php endif;?>
	                    	<?php if(!empty($consua_project_output['title'])):?>
	                        	<h2 class="title"><?php echo wp_kses_post($consua_project_output['title'],'consua_kses_allowed_html');?></h2>
	                        <?php endif;?>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 gallery-content">
                        <div class="magnific-mix-gallery gallery-masonary">
                            <div id="gallery-masonary" class="gallery-items colums-2">
                            	<?php 
                            	$counter = 1;
                            	foreach($consua_project_output['project_list_two'] as $single_project): ?>
	                                <!-- Single Item -->
	                                <div class="gallery-item<?php if($counter == '1'){echo esc_attr(" active");}?>">
	                                    <div class="gallery-style-two">
	                                    	<?php if(!empty($single_project['image']['url'])):?>
	                                        	<img src="<?php echo esc_url($single_project['image']['url']);?>" alt="<?php echo get_bloginfo('name');?>">
	                                        <?php endif;?>
	                                        <?php if(!empty($single_project['shape']['url'])):?>
		                                        <div class="shape">
		                                            <img src="<?php echo esc_url($single_project['shape']['url']);?>" alt="<?php echo get_bloginfo('name');?>">
		                                        </div>
	                                    	<?php endif;?>
	                                        <div class="overlay">
	                                            <div class="content">
	                                                <span><?php echo wp_kses_post($single_project['tagline'],'consua_kses_allowed_html');?></span>
	                                                <h4><a href="<?php echo esc_url($single_project['project_url']['url']);?>"><?php echo wp_kses_post($single_project['title'],'consua_kses_allowed_html');?></a></h4>
	                                            </div>
	                                        </div>
	                                    </div>
	                                </div>
	                                <!-- End Single Item -->
                               	<?php $counter++; endforeach;?>
                            </div>
                        </div>

                        <?php if($consua_project_output['style_two_load_more_txt']):?>
	                        <div class="row">
	                            <div class="col-lg-12 text-center">
	                                <div class="load-more-info text-center mt-60">
	                                    <p>
	                                       <?php echo wp_kses_post($consua_project_output['style_two_load_more_txt'],'consua_kses_allowed_html');?>
	                                    </p>
	                                </div>
	                            </div>
	                        </div>
                    	<?php endif;?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Project Style Two -->

	<?php elseif($consua_project_output['style'] == '4'): ?>

    <!-- Start Project Style Four
    ============================================= -->
    <div class="gallery-style-four-area">

	    <?php if(!empty($consua_project_output['title'] || $consua_project_output['subtitle'])):?>	
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                  		<?php if(!empty($consua_project_output['subtitle'])):?>
	                        	<h4 class="sub-heading"><?php echo wp_kses_post($consua_project_output['subtitle'],'consua_kses_allowed_html');?></h4>
	                    	<?php endif;?>
	                    	<?php if(!empty($consua_project_output['title'])):?>
	                        	<h2 class="title"><?php echo wp_kses_post($consua_project_output['title'],'consua_kses_allowed_html');?></h2>
	                        <?php endif;?>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
	    <?php endif;?>
        
        <div class="container-fill">
            <div class="row">
                <div class="gallery-style-four-carousel swiper">
                    <!-- Additional required wrapper -->
                    <div class="swiper-wrapper">

						<?php 
                        	foreach($consua_project_output['project_list_four'] as $single_project): 
                        ?>
                        <!-- Single Item -->
                        <div class="swiper-slide">
                            <div class="gallery-style-four">
                            	<?php if(!empty($single_project['image']['url'])):?>
                                	<img src="<?php echo esc_url($single_project['image']['url']);?>" alt="<?php echo get_bloginfo('name');?>">
                            	<?php endif;?>
                                <div class="overlay">
                                    <h4><a href="<?php echo esc_url($single_project['project_url']['url']);?>"><?php echo wp_kses_post($single_project['title'],'consua_kses_allowed_html');?></a></h4>
                                    <span><?php echo wp_kses_post($single_project['subtitle'],'consua_kses_allowed_html');?></span>
                                </div>
                            </div>
                        </div>
                        <!-- End Single Item -->
 						<?php endforeach;?>
                    </div>

					<?php if($consua_project_output['nav_show'] == 'yes'): ?>
	                    <!-- Pagination -->
	                    <div class="swiper-pagination"></div>
                	<?php endif;?>

                </div>
            </div>
        </div>
    </div>
    <!-- End Project Style Four  -->

    <?php elseif($consua_project_output['style'] == '5'): ?>
	<!-- Start Project Style Five  -->

    <div class="project-style-three-area">
		<?php if(!empty($consua_project_output['title'] || $consua_project_output['subtitle'])):?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading secondary text-center">
	                       <?php if(!empty($consua_project_output['subtitle'])):?>
	                        	<h4 class="sub-heading"><?php echo wp_kses_post($consua_project_output['subtitle'],'consua_kses_allowed_html');?></h4>
	                    	<?php endif;?>
	                    	<?php if(!empty($consua_project_output['title'])):?>
	                        	<h2 class="title"><?php echo wp_kses_post($consua_project_output['title'],'consua_kses_allowed_html');?></h2>
	                        <?php endif;?>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
        <?php endif;?>
        <div class="container">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 gallery-content">
                        <div class="magnific-mix-gallery gallery-masonary">
                            <div id="gallery-masonary" class="gallery-items colums-3">
								<?php 
	                            	$counter = 1;
	                            	foreach($consua_project_output['project_list_five'] as $single_project):
	                            ?>
	                                <!-- Single Item -->
	                                <div class="gallery-item">
	                                    <div class="gallery-style-three">
	                                        <div class="thumb">
	                                            <?php if(!empty($single_project['image']['url'])):?>
		                                        <img src="<?php echo esc_url($single_project['image']['url']);?>" alt="<?php echo get_bloginfo('name');?>">
		                                        
	                                            <a href="<?php echo esc_url($single_project['image']['url']);?>" class="item popup-gallery">
	                                                <i class="fas fa-plus"></i>
	                                            </a>
	                                            <?php endif;?>
	                                        </div>
	                                        <div class="overlay">
	                                            <div class="content">
	                                                <span><?php echo wp_kses_post($single_project['tagline'],'consua_kses_allowed_html');?></span>
	                                                <h4><a href="<?php echo esc_url($single_project['project_url']['url']);?>"><?php echo wp_kses_post($single_project['title'],'consua_kses_allowed_html');?></a></h4>
	                                            </div>
	                                        </div>
	                                    </div>
	                                </div>
	                                <!-- End Single Item -->
	                            <?php $counter++; endforeach;?>    
                            </div>
                        </div>

 						<?php if($consua_project_output['style_two_load_more_txt']):?>
	                        <div class="row">
	                            <div class="col-lg-12 text-center">
	                                <div class="load-more-info secondary text-center mt-60">
	                                    <p>
	                                       <?php echo wp_kses_post($consua_project_output['style_two_load_more_txt'],'consua_kses_allowed_html');?>
	                                    </p>
	                                </div>
	                            </div>
	                        </div>
	                    <?php endif;?>    
                    </div>
                </div>
            </div>
        </div>
    </div>

	<!-- End Project Style Five  -->
    <?php 	
    endif;
    }
}