<?php
	/**
	* Elementor Service Brochure Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Service_Brochure_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Service Brochure widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_service_brochure';
	}

	/**
	* Get widget title.
	*
	* Retrieve Service Brochure widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Service Brochure', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Service Brochure widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Service Brochure widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		

		$this->start_controls_section(
			'service_brochure_content',
			[
				'label'		=> esc_html__( 'Set Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'rows'          => '2',
				'placeholder' 	=> esc_html__( 'Title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'          => '1',
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'brochure_list',
			[
				'label' 	=> esc_html__( 'Brochure List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Brochure', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'service-brochure-style.php';	
	}

	// Output For User
	protected function render(){
	$consua_service_brochure = $this->get_settings_for_display();
	?>
    <!-- Start Service Brochure
    ============================================= -->
    <div class="single-widget widget-brochure">
        <h4 class="widget-title"><?php echo wp_kses_post($consua_service_brochure['title'],'consua_kses_allowed_html');?></h4>
        <ul>

        	<?php foreach($consua_service_brochure['brochure_list'] as $single_brochure):
        	?>
            <li>
            	<a href="<?php echo esc_url($single_brochure['url']['url']);?>"><i class="fas fa-file-pdf"></i> <?php echo wp_kses_post($single_brochure['title'],'consua_kses_allowed_html');?> </a>
            </li>
            <?php endforeach;?>
        </ul>
    </div>
    <!-- End Service Brochure -->
	<?php 
	}
}