<?php
	/**
	* Elementor consua Service Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Service_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Service widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_service';
	}

	/**
	* Get widget title.
	*
	* Retrieve Service Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Service', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Service Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Service Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}

	public function consua_tab_choose_option(){

		$consua_post_query = new WP_Query( array(
			'post_type'				=> 'consua_tab',
			'posts_per_page'	    => -1,
		) );

		$consua_tab_title = array();
		$consua_tab_title[''] = __( 'Select a Service','consua');

		while( $consua_post_query->have_posts() ) {
			$consua_post_query->the_post();
			$consua_tab_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();

		return $consua_tab_title;

	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'consua_service_style',
			[
				'label'		=> esc_html__( 'Service Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Service Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2' 	=> esc_html__( 'Style Two', 'consua-core' ),
					'3' 	=> esc_html__( 'Style Three', 'consua-core' ),
					'4' 	=> esc_html__( 'Style Four', 'consua-core' ),
					'5' 	=> esc_html__( 'Style Five', 'consua-core' ),
				],
			]
		);


		$this->add_control(
			'section_title',
			[
				'label' 		=> esc_html__( 'Section Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section Title', 'consua-core' ),
				'condition' => [
                    'style' => ['1','2','3','4']
                ]
			]

		);

		$this->add_control(
			'section_subtitle',
			[
				'label' 		=> esc_html__( 'Section Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'section subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Section SubTitle', 'consua-core' ),
				'condition' => [
                    'style' => ['1','2','3','4']
                ]

			]

		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'content', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Content', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$repeater->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$repeater->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$repeater->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$repeater->add_control(
			'service_url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$repeater->add_control(
			'button_label', [
				'label' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'button label', 'consua-core' ),
				'default' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		
		$repeater->add_control(
			'service_image',
			[
				'label'			=> esc_html__( 'Add Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'service_list',
			[
				'label' 	=> esc_html__( 'Service', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Service', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '1'
                ]
			]
		);

		$service_list_three = new \Elementor\Repeater();

		$service_list_three->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$service_list_three->add_control(
			'content', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Subtitle', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$service_list_three->add_control(
			'service_image',
			[
				'label'			=> esc_html__( 'Add Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$service_list_three->add_control(
			'image_icon',
			[
				'label'			=> esc_html__( 'Add Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$service_list_three->add_control(
			'button_label', [
				'label' 		=> esc_html__( 'Button Label', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'button label', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Button Label', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$service_list_three->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$service_list_three->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Button Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$service_list_three->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'consua-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-license',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$service_list_three->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$service_list_three->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'service_list_three',
			[
				'label' 	=> esc_html__( 'Service', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $service_list_three->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Service', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'prevent_empty' => false,
				'condition' => [
                    'style' => '3'
                ]
			]
		);


		$service_four = new \Elementor\Repeater();

		$service_four->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
			]
		);

		$service_four->add_control(
			'consua_tab_builder_option',
			[
				'label'     => __( 'Tab Name', 'ambrox' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => $this->consua_tab_choose_option(),
				'default'	=> ''
			]
		);

		$service_four->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$service_four->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-vegetables',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$service_four->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$service_four->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'service_list_four',
			[
				'label' 	=> esc_html__( 'Service', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $service_four->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Service', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '4'
                ]
			]
		);

		$service_five = new \Elementor\Repeater();

		$service_five->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'    		=> '1', 	
				'label_block' 	=> true,
			]
		);

		$service_five->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'SubTitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'rows'    		=> '3', 	
				'label_block' 	=> true,
			]
		);

		$service_five->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$service_five->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$service_five->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-vegetables',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$service_five->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$service_five->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);
		
		$this->add_control(
			'service_list_five',
			[
				'label' 	=> esc_html__( 'Service', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $service_five->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Service', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '5'
                ]
			]
		);


		$service_style_six = new \Elementor\Repeater();

		$service_style_six->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'label_block' 	=> true,
			]
		);
		$service_style_six->add_control(
			'content', [
				'label' 		=> esc_html__( 'Content', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'content', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Content', 'consua-core' ),
				'label_block' 	=> true,
			]
		);

		$service_style_six->add_control(
			'icon_style',
			[
				'label' 	=> esc_html__( 'Icon Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Flaticon', 'consua-core' ),
					'3' 	=> esc_html__( 'Icon Image', 'consua-core' ),
					'2'  	=> esc_html__( 'Custom Icon', 'consua-core' ),
				],
			]
		);

		$service_style_six->add_control(
			'flat_icon',
			[
                'label'      => esc_html__('Icon One', 'cleanu-core'),
                'type'       => \Elementor\Controls_Manager::ICON,
                'options'    => consua_flaticons(),
                'include'    => consua_include_flaticons(),
                'default'    => 'flaticon-budget',
                'condition' => [
                    'icon_style' => '1'
                ]
            ]
		);

		$service_style_six->add_control(
			'custom_icon', [
				'label' 		=> esc_html__( 'Custom Icon', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'condition' => [
                    'icon_style' => '2'
                ]
			]
		);


		$service_style_six->add_control(
			'icon_image',
			[
				'label'			=> esc_html__( 'Add Image Icon','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'icon_style' => '3'
                ]
			]
		);

		$service_style_six->add_control(
			'url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'service_list_two',
			[
				'label' 	=> esc_html__( 'Service', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $service_style_six->get_controls(),
				'default' 	=> [
					[
						'list_title' => esc_html__( 'Add Service', 'consua-core' ),
					],
				],
				'title_field' => '{{{ title }}}',
				'condition' => [
                    'style' => '2'
                ]
			]
		);

		$this->add_control(
			'service_shape_one',
			[
				'label'			=> esc_html__( 'Background Shape One','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['1','4','2']
                ]
			]
		);

		$this->add_control(
			'service_shape_two',
			[
				'label'			=> esc_html__( 'Background Shape Two','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
                    'style' => ['4']
                ]
			]
		);

		$this->end_controls_section();



		include CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'service-style.php';
	}

	// Output For User
	protected function render(){	
	$consua_service_output = $this->get_settings_for_display();
	if($consua_service_output['style'] == '1'):
	?>
    <!-- Start Services style one
    ============================================= -->
    <div class="services-style-two-area default-padding bottom-less bg-cover bg-gray" style="background-image: url(<?php echo esc_url($consua_service_output['service_shape_one']['url']);?>);">
    	 <?php if(!empty($consua_service_output['section_subtitle'] || $consua_service_output['section_title'])): ?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                    	<?php if(!empty($consua_service_output['section_subtitle'])):?>
		                        <h4 class="sub-heading">
		                        	<?php echo wp_kses_post($consua_service_output['section_subtitle'],'consua_kses_allowed_html');?>
		                        </h4>
	                    	<?php endif;?>
	                    	<?php if(!empty($consua_service_output['section_title'])):?>
		                        <h2 class="title">
		                        	<?php echo wp_kses_post($consua_service_output['section_title'],'consua_kses_allowed_html');?>
		                        </h2>
	                        <?php endif;?>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">
 				<?php
 					$counter = 1;
 				 	foreach($consua_service_output['service_list'] as $single_service):
 				?>	
	                <!-- Single Item -->
	                <div class="col-xl-4 col-md-6 mb-30">
	                    <div class="services-style-two <?php if($counter == '1'){echo esc_attr__("active");}?>">
	                        <div class="thumb">
	                            <?php 
		                            if(!empty($single_service['service_image']['url'])):
							        	echo consua_img_tag( array(
								            'url'   => esc_url( $single_service['service_image']['url'] )
								    	) );
							        endif;
							    ?>
	                            <div class="title">
	                                <a href="<?php echo esc_url($single_service['service_url']['url']) ?>">
					                    <?php if(!empty($single_service['flat_icon'])):?>
					                        <i class="<?php echo esc_attr($single_service['flat_icon']); ?>"></i>
						                    <?php endif;?>
					                    <?php if(!empty($single_service['icon_image'])):?>
					                        <img src="<?php echo esc_url($single_service['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
					                    <?php endif;?>
					                    <?php 
					                    	if(!empty($single_service['custom_icon'])):?>
					                        <i class="<?php echo esc_attr($single_service['custom_icon']); ?>"></i>
					                    <?php endif;?>
	                                    <h4><?php echo wp_kses_post($single_service['title'],'consua_kses_allowed_html');?></h4>
	                                </a>
	                            </div>
	                        </div>
	                        <div class="info">
	                            <p>
	                              	<?php echo wp_kses_post($single_service['content'],'consua_kses_allowed_html');?>
	                            </p>
	                            <?php if(!empty($single_service['service_url']['url'])):?>
		                            <div class="button">
		                                <a href="<?php echo esc_url($single_service['service_url']['url']) ?>"><?php echo esc_html($single_service['button_label']);?></a>
		                                <div class="devider"></div>
		                            </div>
		                        <?php endif;?>
	                        </div>
	                    </div>
	                </div>
	                <!-- End Single Item -->
	            <?php $counter++; endforeach;?>    
            </div>
        </div>
    </div>
    <!-- End Services style one -->

	<?php elseif($consua_service_output['style'] == '3'): ?>

	<!-- Start Services Style Three
    ============================================= -->
    <div class="services-style-four-area bg-gray default-padding bottom-less">

    	<?php if(!empty($consua_service_output['section_subtitle'] || $consua_service_output['section_title'])): ?>	
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                        <h4 class="sub-heading"><?php echo wp_kses_post($consua_service_output['section_subtitle'],'consua_kses_allowed_html');?></h4>
	                        <h2 class="title"><?php echo wp_kses_post($consua_service_output['section_title'],'consua_kses_allowed_html');?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">

            	<?php
 				 	foreach($consua_service_output['service_list_three'] as $single_service):
 				?>
                <!-- Single Item -->
                <div class="col-xl-4 col-md-6 mb-30">
                    <div class="service-style-four">
                        <div class="info">
                            <h4><a href="<?php echo esc_url($single_service['url']['url']);?>"><?php echo wp_kses_post($single_service['title'],'consua_kses_allowed_html');?></a></h4>
                            <p>
                               <?php echo wp_kses_post($single_service['content'],'consua_kses_allowed_html');?>
                            </p>
                            <div class="icon">
                                <div class="thumb">
                                   <?php 
			                            if(!empty($single_service['image_icon']['url'])):
								        	echo consua_img_tag( array(
									            'url'   => esc_url( $single_service['image_icon']['url'] )
									    	) );
								        endif;
								    ?>
                                </div>
                                <a href="<?php echo esc_url($single_service['url']['url']);?>" class="link"><?php echo wp_kses_post($single_service['button_label'],'consua_kses_allowed_html');?><?php if(!empty($single_service['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($single_service['flat_icon']); ?>"></i>
					                    <?php endif;?>
				                    <?php if(!empty($single_service['icon_image']['url'])):?>
				                        <img src="<?php echo esc_url($single_service['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
				                    <?php endif;?>
				                    <?php 
				                    	if(!empty($single_service['custom_icon'])):?>
				                        <i class="<?php echo esc_attr($single_service['custom_icon']); ?>"></i>
				                    <?php endif;?></a>
                            </div>
                        </div>
                        <div class="thumb">
                          	<?php 
	                            if(!empty($single_service['service_image']['url'])):
						        	echo consua_img_tag( array(
							            'url'   => esc_url( $single_service['service_image']['url'] )
							    	) );
						        endif;
						    ?>
                        </div>
                    </div>
                </div>
                <!-- Single Item -->
               <?php endforeach;?> 

            </div>
        </div>
    </div>
    <!-- End Services Style Three-->

	<?php elseif($consua_service_output['style'] == '4'): ?>

    <!-- Start Servics Style One 
    ============================================= -->
    <div class="services-style-one-area default-padding bg-gray">
    	<?php if(!empty($consua_service_output['service_shape_one']['url'])):?>
	        <div class="triangle-shape">
	            <img src="<?php echo esc_url($consua_service_output['service_shape_one']['url']);?>" alt="Shape">
	        </div>
    	<?php endif;?>
    	<?php if(!empty($consua_service_output['service_shape_two']['url'])):?>
        	<div class="center-shape" style="background-image: url(<?php echo esc_url($consua_service_output['service_shape_two']['url']);?>);"></div>
        <?php endif;?>
        <div class="container">
            <div class="row align-center">
                <div class="col-lg-5 mb-md-60">
                    <div class="service-nav-info">
                        <h4 class="sub-title">  <?php echo wp_kses_post($consua_service_output['section_subtitle'],'consua_kses_allowed_html');?></h4>
                        <h2><?php echo wp_kses_post($consua_service_output['section_title'],'consua_kses_allowed_html');?></h2>
                        <div class="nav nav-tabs service-tab-navs" id="nav-tab" role="tablist">
							<?php
								$counter = 1;
			 				 	foreach($consua_service_output['service_list_four'] as $single_service):
			 				?>
	                            <button class="nav-link  <?php if($counter == '1'){echo esc_attr("show active");}?>" id="nav-id-<?php echo esc_attr($counter);?>" data-bs-toggle="tab" data-bs-target="#tab<?php echo esc_attr($counter);?>" type="button" role="tab" aria-controls="tab1" aria-selected="true">
	                                <?php if(!empty($single_service['flat_icon'])):?>
				                        <i class="<?php echo esc_attr($single_service['flat_icon']); ?>"></i>
					                    <?php endif;?>
				                    <?php if(!empty($single_service['icon_image']['url'])):?>
				                        <img src="<?php echo esc_url($single_service['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
				                    <?php endif;?>
				                    <?php 
				                    	if(!empty($single_service['custom_icon'])):?>
				                        <i class="<?php echo esc_attr($single_service['custom_icon']); ?>"></i>
				                    <?php endif;?>
	                            <?php echo esc_html($single_service['title']);?>
	                            </button>
							<?php $counter++; endforeach;?> 
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 pl-50 pl-md-15 pl-xs-15">
                    <div class="tab-content services-tab-content" id="nav-tabContent">
						<?php
							$counter = 1;
		 				 	foreach($consua_service_output['service_list_four'] as $single_service):
		 				?>
	                        <!-- Tab Single Item -->
	                        <div class="tab-pane fade <?php if($counter == '1'){echo esc_attr("show active");}?>" id="tab<?php echo esc_attr($counter);?>" role="tabpanel" aria-labelledby="nav-id-<?php echo esc_attr($counter);?>">
	                        <?php
	                            $elementor = \Elementor\Plugin::instance();
								if( ! empty( $single_service['consua_tab_builder_option'] ) ){
								    echo $elementor->frontend->get_builder_content_for_display( $single_service['consua_tab_builder_option'] );
								}
							?>
	                        </div>
	                        <!-- End Tab Single Item -->
	                    <?php $counter++; endforeach;?>     
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Services Style One -->

	<?php elseif($consua_service_output['style'] == '5'): ?>

	<div class="row">

		<?php
		 	foreach($consua_service_output['service_list_five'] as $single_service):
		?>
	        <!-- Single Item -->
	        <div class="col-lg-6 col-md-6 mt-60 mt-md-30 mt-xs-30">
	            <div class="services-style-one">
	                <?php if(!empty($single_service['flat_icon'])):?>
                        <i class="<?php echo esc_attr($single_service['flat_icon']); ?>"></i>
	                    <?php endif;?>
                    <?php if(!empty($single_service['icon_image']['url'])):?>
                        <img src="<?php echo esc_url($single_service['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
                    <?php endif;?>
                    <?php 
                    	if(!empty($single_service['custom_icon'])):?>
                        <i class="<?php echo esc_attr($single_service['custom_icon']); ?>"></i>
                    <?php endif;?>
	                <h4><a href="<?php echo esc_url($single_service['url']['url']);?>"><?php echo wp_kses_post($single_service['title'],'consua_kses_allowed_html');?></a></h4>
	                <p>
	                    <?php echo wp_kses_post($single_service['subtitle'],'consua_kses_allowed_html');?>
	                </p>
	            </div>
	        </div>
	        <!-- End Single Item -->
       	<?php endforeach;?> 
    </div>	

    <?php elseif($consua_service_output['style'] == '2'): ?>

    <!-- Start Services Six
    ============================================= -->
    <div class="services-style-three-area default-padding-top half-bg-dark" style="background-image: url(<?php echo esc_url($consua_service_output['service_shape_one']['url']);?>);">

		<?php if(!empty($consua_service_output['section_subtitle'] || $consua_service_output['section_title'])): ?>	
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading secondary text-center">
	                        <h4 class="sub-heading"><?php echo wp_kses_post($consua_service_output['section_subtitle'],'consua_kses_allowed_html');?></h4>
	                        <h2 class="title"><?php echo wp_kses_post($consua_service_output['section_title'],'consua_kses_allowed_html');?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>

        <div class="container container-stage">
            <div class="row">
                <div class="col-lg-12">
                    <div class="services-carousel swiper">
                        <!-- Additional required wrapper -->
                        <div class="swiper-wrapper">
                        	<?php
			 				 	foreach($consua_service_output['service_list_two'] as $single_service):
			 				?>
	                            <!-- Single Item -->
	                            <div class="swiper-slide">
	                                <div class="services-style-three">
	                                    <div class="info">
	                                       <?php if(!empty($single_service['flat_icon'])):?>
						                        <i class="<?php echo esc_attr($single_service['flat_icon']); ?>"></i>
							                    <?php endif;?>
						                    <?php if(!empty($single_service['icon_image']['url'])):?>
						                        <img src="<?php echo esc_url($single_service['icon_image']['url']); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
						                    <?php endif;?>
						                    <?php 
						                    	if(!empty($single_service['custom_icon'])):?>
						                        <i class="<?php echo esc_attr($single_service['custom_icon']); ?>"></i>
						                    <?php endif;?>
	                                        <h3>
	                                        	<a href="<?php echo esc_url($single_service['url']['url']);?>"><?php echo wp_kses_post($single_service['title'],'consua_kses_allowed_html');?>
	                                        	</a>
	                                        </h3>
	                                        <p>
	                                           <?php echo wp_kses_post($single_service['content'],'consua_kses_allowed_html');?>
	                                        </p>
	                                        
	                                    </div>
	                                </div>
	                            </div>
	                            <!-- End Single Item -->
                           	<?php endforeach;?> 
                            
                        </div>

                        <!-- Navigation -->
                        <div class="services-swiper-nav">
                            <!-- Pagination -->
                            <div class="services-pagination"></div>

                            <div class="services-button-prev"></div>
                            <div class="services-button-next"></div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Services -->
    	
    <?php
	endif;
    }
}