<?php
	/**
	* Elementor Shape Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Shape_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Shape widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_shape_widget';
	}

	/**
	* Get widget title.
	*
	* Retrieve Shape widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Shape', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Shape widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Shape widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		
		$this->start_controls_section(
			'shape_content',
			[
				'label'		=> esc_html__( 'Set Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'animation_top',
			[
				'label' => esc_html__( 'Top', 'cleanu-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .item' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'animation_buttom',
			[
				'label' => esc_html__( 'Buttom', 'cleanu-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .item' => 'buttom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'animation_right',
			[
				'label' => esc_html__( 'Right', 'cleanu-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .item' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'animation_left',
			[
				'label' => esc_html__( 'Left', 'cleanu-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .item' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label'			=> esc_html__( 'Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->end_controls_section();

	}

	// Output For User
	protected function render(){
	$consua_shape_output = $this->get_settings_for_display();
	?>
    <!-- Start Shape 
    ============================================= -->
    <div class="footer-shape">
    	<div class="item">
        	<img src="<?php echo esc_url($consua_shape_output['image']['url']);?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
    	</div>
    </div>
    <!-- End Shape -->
	<?php 
	}
}