<?php
	/**
	* Elementor consua teams Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Team_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve teams widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_team';
	}

	/**
	* Get widget title.
	*
	* Retrieve teams Nav Tab widget title.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Team Member', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve teams Nav Tab widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the teams Nav Tab widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements' ];
	}
	
	// Add The Input For User
	protected function register_controls(){

		$this->start_controls_section(
			'consua_team_style',
			[
				'label'		=> esc_html__( 'Team Style','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' 	=> esc_html__( 'Style', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  	=> esc_html__( 'Style One', 'consua-core' ),
					'2'  	=> esc_html__( 'Style Two', 'consua-core' ),
					'3'  	=> esc_html__( 'Style Three', 'consua-core' ),
				],
			]
		);

		$this->add_control(
			'title', [
				'label' 		=> esc_html__( 'Title', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'title', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Title', 'consua-core' ),
				'rows' => 	'2',
			]
		);
		$this->add_control(
			'subtitle', [
				'label' 		=> esc_html__( 'Subtitle', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'subtitle', 'consua-core' ),
				'default' 		=> esc_html__( 'Default SubTitle', 'consua-core' ),
				'rows' => 	'2',
			]
		);

		$this->add_control(
			'summary', [
				'label' 		=> esc_html__( 'Summary', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'summary', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Summary', 'consua-core' ),
				'rows' => 	'3',
				'condition'		=> [ 'style'	=>	'2' ],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> esc_html__( 'Name', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'name', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Name', 'consua-core' ),
				'rows' => 	'2',
			]
		);
		$repeater->add_control(
			'designation', [
				'label' 		=> esc_html__( 'Designation', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'designation', 'consua-core' ),
				'default' 		=> esc_html__( 'Default Designation', 'consua-core' ),
				'label_block' 	=> true,
				'rows' => 	'2',
			]
		);

		$repeater->add_control(
			'team_image',
			[
				'label'			=> esc_html__( 'Add Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'team_url',
			[
				'label' 		=> esc_html__( 'URL', 'consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'consua-core' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$repeater->add_control(
            'social_network',
            [
                'label' => __('Social NetWork', 'insur-addon'),
                'type' => \Elementor\Controls_Manager::CODE,
                'label_block' => true,
                'default' => wp_kses('<li class="facebook"> <a class="facebook" href="#"> <i class="fab fa-facebook-f"></i> </a> </li>', 'consua_kses_allowed_html')
            ]
        );

		$this->add_control(
			'team_list',
			[
				'label' 	=> esc_html__( 'Team List', 'consua-core' ),
				'type' 		=> \Elementor\Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'prevent_empty' => 'false',
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'bac_shape',
			[
				'label'			=> esc_html__( 'Add Background Shape Image','consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		
		$this->end_controls_section();

		INCLUDE CONSUA_PLUGIN_WIDGET_STYLE_PATH . 'team-style.php';
	}

	// Output For User
	protected function render(){	
	$consua_team_output = $this->get_settings_for_display();
	if($consua_team_output['style'] == '1'):
	?>

    <!-- Start Team Style One
    ============================================= -->
    <div class="team-style-onea-rea default-padding-top pb-70 pb-xs-0 bg-contain-center" style="background-image: url(<?php echo esc_url($consua_team_output['bac_shape']['url']); ?>);">
    	<?php if(!empty($consua_team_output['subtitle'] || $consua_team_output['title'])): ?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                        <h4 class="sub-heading"><?php echo wp_kses_post($consua_team_output['subtitle'],'consua_kses_allowed_html');?></h4>
	                        <h2 class="title"><?php echo wp_kses_post($consua_team_output['title'],'consua_kses_allowed_html');?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">
            	<?php
            	$counter = 1;
            	foreach($consua_team_output['team_list'] as $single_team): ?>
	                <!-- Single Item -->
	                <div class="col-xl-3 col-md-6">
	                    <div class="team-style-one<?php if($counter == '1'){echo esc_attr(" active");}?>">
	                        <div class="thumb">
	                            <?php
						        	if(!empty($single_team['team_image']['url'])): 
							        	echo consua_img_tag( array(
								            'url'   => esc_url( $single_team['team_image']['url'] )
								    	) );
						        	endif;
							    ?>
							    <?php if(!empty($single_team['social_network'])):?>
		                            <div class="social">
		                                <ul>
		                                	<?php echo wp_kses_post($single_team['social_network'],'consua_kses_allowed_html');?>
		                                </ul>
		                            </div>
	                        	<?php endif;?>
	                        </div>
	                        <div class="info">
	                            <span><?php echo esc_html($single_team['designation']);?></span>
	                            <h4><a href="<?php echo esc_url($single_team['team_url']['url']);?>"><?php echo wp_kses_post($single_team['title'],'consua_kses_allowed_html');?></a></h4>
	                        </div>
	                    </div>
	                </div>
	                <!-- End Single Item -->
                <?php $counter++ ;endforeach;?>
            </div>
        </div>
    </div>
    <!-- End Team Style One -->

	<?php elseif($consua_team_output['style'] == '2'):?>

	 <!-- Start Team Style Two
    ============================================= -->
    <div class="team-style-two-area secondary bg-gray default-padding" style="background-image: url(<?php echo esc_url($consua_team_output['bac_shape']['url']); ?>);">

    	<?php if(!empty($consua_team_output['subtitle'] || $consua_team_output['title'] || $consua_team_output['summary'])):?>
	        <div class="container">
	            <div class="heading-left">
	                <div class="row">
	                    <div class="col-lg-5">
	                        <div class="content-left secondary">
	                            <h5 class="sub-heading"> <?php echo wp_kses_post($consua_team_output['subtitle'],'consua_kses_allowed_html');?></h5>
	                            <h2 class="heading"> <?php echo wp_kses_post($consua_team_output['title'],'consua_kses_allowed_html');?></h2>
	                        </div>
	                    </div>
	                    <div class="col-lg-6 offset-lg-1">
	                        <p>
	                            <?php echo wp_kses_post($consua_team_output['summary'],'consua_kses_allowed_html');?>
	                        </p>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="team-carousel swiper">
                        <!-- Additional required wrapper -->
                        <div class="swiper-wrapper">
                        	<?php
			            	$counter = 1;
			            	foreach($consua_team_output['team_list'] as $single_team): ?>
	                            <!-- Single Item -->
	                            <div class="swiper-slide">
	                                <div class="team-style-two">
	                                    <div class="thumb">
	                                       <?php
									        	if(!empty($single_team['team_image']['url'])): 
										        	echo consua_img_tag( array(
											            'url'   => esc_url( $single_team['team_image']['url'] )
											    	) );
									        	endif;
										    ?>
										    <?php if(!empty($single_team['social_network'])):?>
		                                        <ul class="social">
		                                            <?php echo wp_kses_post($single_team['social_network'],'consua_kses_allowed_html');?>
		                                        </ul>
	                                    	<?php endif;?>
	                                    </div>
	                                    <div class="info">
	                                        <div class="content">
	                                            <h4 class="title"><a href="team-details.html"><?php echo wp_kses_post($single_team['title'],'consua_kses_allowed_html');?></a></h4>
	                                            <span><?php echo wp_kses_post($single_team['designation'],'consua_kses_allowed_html');?></span>
	                                        </div>
	                                    </div>
	                                </div>
	                            </div>
	                            <!-- End Single Item -->
                            <?php $counter++ ;endforeach;?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Team Style Two -->

	<?php elseif($consua_team_output['style'] == '3'):?>

	 <!-- Start Team Style Three
    ============================================= -->
    <div class="team-style-onea-rea default-padding-top pb-70 pb-xs-0 bg-contain-center bg-gray" style="background-image: url(<?php echo esc_url($consua_team_output['bac_shape']['url']); ?>);">
    	<?php if(!empty($consua_team_output['subtitle'] || $consua_team_output['title'])): ?>
	        <div class="container">
	            <div class="row">
	                <div class="col-lg-8 offset-lg-2">
	                    <div class="site-heading text-center">
	                        <h4 class="sub-heading"><?php echo wp_kses_post($consua_team_output['subtitle'],'consua_kses_allowed_html');?></h4>
	                        <h2 class="title"><?php echo wp_kses_post($consua_team_output['title'],'consua_kses_allowed_html');?></h2>
	                        <div class="devider"></div>
	                    </div>
	                </div>
	            </div>
	        </div>
    	<?php endif;?>
        <div class="container">
            <div class="row">
            	<?php
            	$counter = 1;
            	foreach($consua_team_output['team_list'] as $single_team): ?>
	                <!-- Single Item -->
	                <div class="col-xl-3 col-md-6">
	                    <div class="team-style-one">
	                        <div class="thumb">
	                            <?php
						        	if(!empty($single_team['team_image']['url'])): 
							        	echo consua_img_tag( array(
								            'url'   => esc_url( $single_team['team_image']['url'] )
								    	) );
						        	endif;
							    ?>
							    <?php if(!empty($single_team['social_network'])):?>
		                            <div class="social">
		                                <ul>
		                                	<?php echo wp_kses_post($single_team['social_network'],'consua_kses_allowed_html');?>
		                                </ul>
		                            </div>
	                        	<?php endif;?>
	                        </div>
	                        <div class="info">
	                            <span><?php echo esc_html($single_team['designation']);?></span>
	                            <h4><a href="<?php echo esc_url($single_team['team_url']['url']);?>"><?php echo wp_kses_post($single_team['title'],'consua_kses_allowed_html');?></a></h4>
	                        </div>
	                    </div>
	                </div>
	                <!-- End Single Item -->
                <?php $counter++ ;endforeach;?>
            </div>
        </div>
    </div>
    <!-- End Team Style Three -->

    <?php
    endif; 	
    }
}