<?php
	/**
	* Elementor Video Widget.
	*
	* Elementor widget that inserts an embbedable content into the page, from any given URL.
	*
	* @since 1.0.0
	*/
class Elementor_Consua_Video_Widget extends \Elementor\Widget_Base {

	/**
	* Get widget name.
	*
	* Retrieve Video widget name.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget name.
	*/
	public function get_name() {
		return 'consua_video_widget';
	}

	/**
	* Get widget title.
	*
	* Retrieve Video widget title.
	*
	* @since 1.0.0
	* @access public 
	*
	* @return string Widget title.
	*/
	public function get_title() {
		return esc_html__( 'Video', 'consua-core' );
	}

	/**
	* Get widget icon.
	*
	* Retrieve Video widget icon.
	*
	* @since 1.0.0
	* @access public
	*
	* @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	* Get widget categories.
	*
	* Retrieve the list of categories the Video widget belongs to.
	*
	* @since 1.0.0
	* @access public
	*
	* @return array Widget categories.
	*/
	public function get_categories() {
		return [ 'consua_elements'];
	}

	public function get_script_depends() {
        return array('main');
    }

	// Add The Input For User
	protected function register_controls(){
		
		$this->start_controls_section(
			'video_content',
			[
				'label'		=> esc_html__( 'Set Video Content','consua-core' ),
				'tab'		=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'video_image',
			[
				'label'			=> esc_html__( 'Background Image','Consua-core' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'video_url',
			[
				'label' 		=> __( 'Video Url', 'consua' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'consua' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);


		$this->end_controls_section();

	}

	// Output For User
	protected function render(){
	$consua_video_output = $this->get_settings_for_display();
	?>
    <!-- Start Video 
    ============================================= -->
    <div class="software-video overflow-hidden">
        
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="software-video-preview bg-cover">
                        <div class="video-bg-live" style="background-image: url(<?php echo esc_url($consua_video_output['video_image']['url']);?>);">
                            <div class="shadow-overlay"></div>
                            <div class="player" data-property="{videoURL:'ux4wGE2_jO4',containment:'.video-bg-live', showControls:false, autoPlay:true, zoom:0, loop:true, mute:true, startAt:0, stopAt:25, opacity:1, quality:'default'}"></div>

                            <?php if(!empty($consua_video_output['video_url']['url'])):?>
                            	<a href="<?php echo esc_url($consua_video_output['video_url']['url'])?>" class="popup-youtube video-play-button">
                                <i class="fas fa-play"></i>
                                <div class="effect"></div>
                            	</a>
                        	<?php endif;?>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Video -->
	<?php 
	}
}