<?php 

$this->start_controls_section(
	'about_section_style_option',
	[
		'label'			=> esc_html__( 'About Content Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_highlight_title_option',
	[
		'label' 		=> esc_html__( 'Section Highlight Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['5']
        ]
	]
);
$this->add_control(
	'section_highlight_title_color',
	[
		'label' 		=> esc_html__( 'Highlight Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .about-style-five-thumb h2' => 'color: {{VALUE}}',
		],
		'condition' => [
           'style' => ['5']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_highlight_title_typography',
		'label' 		=> esc_html__( 'Highlight Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .about-style-five-thumb h2',
		'condition' => [
            'style' => ['5']
        ]
	]
);


$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Section Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','3','4','5','6','2']
        ]
	]
);
$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .heading,{{WRAPPER}} .title,{{WRAPPER}} .about-style-five-info h2,{{WRAPPER}} .about-style-six-info h2' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['1','3','4','5','6','2']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .heading,{{WRAPPER}} .title,{{WRAPPER}} .about-style-five-info h2,{{WRAPPER}} .about-style-six-info h2',
		'condition' => [
            'style' => ['1','3','4','5','6','2']
        ]
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'Section Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','3','4','6']
        ]
	]
);
$this->add_control(
	'section_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .sub-heading.secondary,{{WRAPPER}} .sub-heading' => 'color: {{VALUE}}',
		],
		'condition' => [
             'style' => ['1','3','4','6']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .sub-heading.secondary,{{WRAPPER}} .sub-heading',
		'condition' => [
            'style' => ['1','3','4','6']
        ]
	]
);

$this->add_control(
	'section_summary_option',
	[
		'label' 		=> esc_html__( 'Section Summary Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
           'style' => ['1','4','5','6','2']        ]
	]
);

$this->add_control(
	'section_summary_color',
	[
		'label' 		=> esc_html__( 'Summary Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .about-style-four-area p,{{WRAPPER}} .about-style-five-info p,{{WRAPPER}} .about-style-six-info p,{{WRAPPER}} .about-style-one p,{{WRAPPER}} .about-style-two p' => 'color: {{VALUE}}',
		],
		'condition' => [
           'style' => ['1','4','5','6','2']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_summary_typography',
		'label' 		=> esc_html__( 'Summary Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .about-style-four-area p,{{WRAPPER}} .about-style-five-info p,{{WRAPPER}} .about-style-six-info p,,{{WRAPPER}} .about-style-one p,{{WRAPPER}} .about-style-two p',
		'condition' => [
           'style' => ['1','4','5','6','2']        ]
	]
);


$this->add_control(
	'choose_title_option',
	[
		'label' 		=> esc_html__( 'Choose Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['3','4']
        ]
	]
);
$this->add_control(
	'choose_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .list-item-style-two h4' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['3','4']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'choose_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .list-item-style-two h4',
		'condition' => [
            'style' => ['3','4']
        ]
	]
);

$this->add_control(
	'choose_subtitle_option',
	[
		'label' 		=> esc_html__( 'Choose SubTitle Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['3','4']
        ]
	]
);
$this->add_control(
	'choose_subtitle_color',
	[
		'label' 		=> esc_html__( 'SubTitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .list-item-style-two p' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['3','4']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'choose_subtitle_typography',
		'label' 		=> esc_html__( 'SubTitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .list-item-style-two p',
		'condition' => [
            'style' => ['3','4']
        ]
	]
);

$this->add_control(
	'counter_title_option',
	[
		'label' 		=> esc_html__( 'Counter Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','4','5']
        ]
	]
);
$this->add_control(
	'counter_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .fun-fact .medium,{{WRAPPER}} .about-style-five-info ul li span.medium,{{WRAPPER}} .about-card .fun-fact .medium' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['1','4','5']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'counter_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .fun-fact .medium,{{WRAPPER}} .about-style-five-info ul li span.medium,{{WRAPPER}} .about-card .fun-fact .medium',
		'condition' => [
             'style' => ['1','4','5']
        ]
	]
);


$this->add_control(
	'counter_number_option',
	[
		'label' 		=> esc_html__( 'Counter Number Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
             'style' => ['1','4','5']
        ]
	]
);
$this->add_control(
	'choose_number_color',
	[
		'label' 		=> esc_html__( 'Number Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .about-style-four .fun-fact .counter,{{WRAPPER}} .about-style-five-info ul li .counter,{{WRAPPER}} .about-card .fun-fact .counter' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['1','4','5']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'choose_number_typography',
		'label' 		=> esc_html__( 'Number Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .about-style-four .fun-fact .counter,{{WRAPPER}} .about-style-five-info ul li .counter,{{WRAPPER}} .about-card .fun-fact .counter',
		'condition' => [
            'style' => ['1','4','5']        ]
	]
);


$this->add_control(
	'author_name_option',
	[
		'label' 		=> esc_html__( 'Author Name Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['1','4']
        ]
	]
);
$this->add_control(
	'author_name_color',
	[
		'label' 		=> esc_html__( 'Name Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .company-autor .left-info h4,{{WRAPPER}} .owner-info h4' => 'color: {{VALUE}}',
		],
		'condition' => [
             'style' => ['1','4']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'author_name_typography',
		'label' 		=> esc_html__( 'Name Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .company-autor .left-info h4,{{WRAPPER}} .owner-info h4',
		'condition' => [
            'style' => ['1','4']]
	]
);


$this->add_control(
	'point_list_option',
	[
		'label' 		=> esc_html__( 'Point List Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['6']
        ]
	]
);
$this->add_control(
	'point_list_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} ul.list-regular li' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['6']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'point_list_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} ul.list-regular li',
		'condition' => [
            'style' => ['6']
        ]
	]
);

$this->add_control(
	'feature_list_option',
	[
		'label' 		=> esc_html__( 'Feature List Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => ['2']
        ]
	]
);
$this->add_control(
	'feature_list_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .default-feature-item h4' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => ['2']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'feature_list_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .default-feature-item h4',
		'condition' => [
            'style' => ['2']
        ]
	]
);


$this->end_controls_section();