<?php 

$this->start_controls_section(
	'banner_section_style_option',
	[
		'label'			=> esc_html__( 'Banner Section Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .banner-style-one h2,{{WRAPPER}} .banner-style-two h2,{{WRAPPER}} .banner-style-four h2,{{WRAPPER}} .banner-style-three .content h2,{{WRAPPER}}  .banner-style-five h2,{{WRAPPER}} .banner-style-six h2' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .banner-style-one h2,{{WRAPPER}} .banner-style-two h2,{{WRAPPER}} .banner-style-four h2,{{WRAPPER}} .banner-style-three .content h2, {{WRAPPER}}  .banner-style-five h2,{{WRAPPER}} .banner-style-six h2',
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'section_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .banner-style-one h4,{{WRAPPER}} .banner-style-two p,{{WRAPPER}} .banner-style-four p,{{WRAPPER}} .banner-style-three .content h4,{{WRAPPER}} .banner-style-five h4,{{WRAPPER}} .banner-style-six h4' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .banner-style-one h4,{{WRAPPER}} .banner-style-two p,{{WRAPPER}} .banner-style-four p,{{WRAPPER}} .banner-style-three .content h4,{{WRAPPER}}  .banner-style-five h4,{{WRAPPER}} .banner-style-six h4',
	]
);


$this->add_control(
	'section_summary_option',
	[
		'label' 		=> esc_html__( 'Summary Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'banner_style' => ['4','6']
        ]
	]
);
$this->add_control(
	'section_summary_color',
	[
		'label' 		=> esc_html__( 'Summary Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .banner-style-three .content ul li,{{WRAPPER}} .banner-style-six p' => 'color: {{VALUE}}',
		],
		'condition' => [
             'banner_style' => ['4','6']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_summary_typography',
		'label' 		=> esc_html__( 'Summary Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .banner-style-three .content ul li,{{WRAPPER}} .banner-style-six p',
		'condition' => [
            'banner_style' => ['4','6']
        ]
	]
);


$this->add_control(
	'section_button_option',
	[
		'label' 		=> esc_html__( 'Button Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'banner_style' => ['1','2','3','4','6']
        ]
	]
);
$this->add_control(
	'section_button_color',
	[
		'label' 		=> esc_html__( 'Button Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .btn-animation span,{{WRAPPER}} .btn.btn-theme,{{WRAPPER}} .btn.btn-theme.secondary' => 'color: {{VALUE}}',
		],
		'condition' => [
            'banner_style' => ['1','2','3','4','6']
        ]
	]
);

$this->add_control(
	'section_button_bg_color',
	[
		'label' 		=> esc_html__( 'Button Background Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .btn-animation span,{{WRAPPER}} .btn.btn-theme,{{WRAPPER}} .btn.btn-theme.secondary' => 'background-color: {{VALUE}}',
		],
		'condition' => [
            'banner_style' => ['1','2','3','4']
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_button_typography',
		'label' 		=> esc_html__( 'Button Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .btn-animation span, {{WRAPPER}} .btn.btn-theme,,{{WRAPPER}} .btn.btn-theme.secondary',
		'condition' => [
            'banner_style' => ['1','2','3','4','6']
        ]
	]
);


$this->add_control(
	'section_video_txt_option',
	[
		'label' 		=> esc_html__( 'Video Text Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'banner_style' => '5'
        ]
	]
);
$this->add_control(
	'section_video_text_color',
	[
		'label' 		=> esc_html__( 'Video Text Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .video-play-button.with-text span' => 'color: {{VALUE}}',
		],
		'condition' => [
            'banner_style' => '5'
        ]
	]
);


$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_video_text_typography',
		'label' 		=> esc_html__( 'Video Text Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .video-play-button.with-text span',
		'condition' => [
            'banner_style' => '5'
        ]
	]
);

$this->end_controls_section();