<?php 

$this->start_controls_section(
	'overview_section_style_option',
	[
		'label'			=> esc_html__( 'Section Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);

$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .site-heading .title' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .site-heading .title',
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);

$this->add_control(
	'section_subtitle_color_1',
	[
		'label' 		=> __( 'Subtitle Color 1 ', 'crysa-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
	]
);
$this->add_control(
	'section_subtitle_color_2',
	[
		'label' 		=> __( 'Subtitle Color 2', 'crysa-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .bg-dark.secondary .sub-heading' => 'background: linear-gradient(90deg, {{section_subtitle_color_1.VALUE}} 0%, {{VALUE}} 100%);',
        ],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .bg-dark.secondary .sub-heading',
	]
);

$this->end_controls_section();

$this->start_controls_section(
	'overview_content_style_option',
	[
		'label'			=> esc_html__( 'Content Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'content_tab_title_option',
	[
		'label' 		=> esc_html__( 'Tab Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_tab_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .software-tab-navs.nav-tabs .nav-link' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_tab_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .software-tab-navs.nav-tabs .nav-link',
	]
);

$this->add_control(
	'content_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .soft-overview .overlay h3' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .soft-overview .overlay h3',
	]
);

$this->add_control(
	'content_subtitle_option',
	[
		'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .soft-overview .overlay p' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .soft-overview .overlay p',
	]
);

$this->end_controls_section();