<?php 

$this->start_controls_section(
	'partner_section_style_option',
	[
		'label'			=> esc_html__( 'Partner Contnet Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .partner-map h4,{{WRAPPER}} .partner-heading h3' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .partner-map h4,{{WRAPPER}} .partner-heading h3',
	]
);

$this->add_control(
	'section_number_option',
	[
		'label' 		=> esc_html__( 'Heading Number Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition' => [
            'style' => '2'
        ]
	]
);
$this->add_control(
	'section_number_color',
	[
		'label' 		=> esc_html__( 'Number Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .partner-heading h3 strong' => 'color: {{VALUE}}',
		],
		'condition' => [
            'style' => '2'
        ]
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_number_typography',
		'label' 		=> esc_html__( 'Number Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .partner-heading h3 strong',
		'condition' => [
            'style' => '2'
        ]
	]
);

$this->end_controls_section();