<?php 

$this->start_controls_section(
	'project_section_style_option',
	[
		'label'			=> esc_html__( 'Section Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'section_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);

$this->add_control(
	'section_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .site-heading .title' => 'color: {{VALUE}}',
		],
	]
);

$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'heading_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .site-heading .title',
	]
);

$this->add_control(
	'section_subtitle_option',
	[
		'label' 		=> esc_html__( 'Sub-Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'section_subtitle_color',
	[
		'label' 		=> esc_html__( 'Subtitle Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .text-center .sub-heading, .text-center.sub-heading,{{WRAPPER}}  .home-solar .sub-heading' => 'background: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'section_subtitle_typography',
		'label' 		=> esc_html__( 'Subtitle Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .text-center .sub-heading, .text-center.sub-heading,{{WRAPPER}} .home-solar .sub-heading',
	]
);

$this->end_controls_section();

$this->start_controls_section(
	'project_content_style_option',
	[
		'label'			=> esc_html__( 'Content Style','consua-core' ),
		'tab' 			=> \Elementor\Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'content_title_option',
	[
		'label' 		=> esc_html__( 'Title Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_title_color',
	[
		'label' 		=> esc_html__( 'Title Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .overlay .content a,{{WRAPPER}} .gallery-style-four-area h4 a' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_title_typography',
		'label' 		=> esc_html__( 'Title Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .overlay .content a,{{WRAPPER}} .gallery-style-four-area. h4 a',
	]
);

$this->add_control(
	'content_tagline_option',
	[
		'label' 		=> esc_html__( 'Tagline Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
	]
);
$this->add_control(
	'content_tagline_color',
	[
		'label' 		=> esc_html__( 'Tagline Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .overlay span,{{WRAPPER}} .gallery-style-four .overlay span' => 'color: {{VALUE}}',
		],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_tagline_typography',
		'label' 		=> esc_html__( 'Tagline Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .overlay span,{{WRAPPER}} .gallery-style-four .overlay span',
	]
);

$this->add_control(
	'content_loadmore_option',
	[
		'label' 		=> esc_html__( 'Loadmore Text Options', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::HEADING,
		'separator' 	=> 'before',
		'condition'		=> [ 'style'	=>	['1','2'] ],
	]
);
$this->add_control(
	'content_loadmore_color',
	[
		'label' 		=> esc_html__( 'Loadmore Text Color', 'consua-core' ),
		'type' 			=> \Elementor\Controls_Manager::COLOR,
		'selectors' 	=> [
			'{{WRAPPER}} .load-more-info p,{{WRAPPER}} .secondary.load-more-info a' => 'color: {{VALUE}}',
		],
		'condition'		=> [ 'style'	=>	['1','2','5'] ],
	]
);
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' 			=> 'content_loadmore_typography',
		'label' 		=> esc_html__( 'Loadmore Text Typography', 'consua-core' ),
		'selector' 		=> '{{WRAPPER}} .load-more-info p,{{WRAPPER}} .secondary.load-more-info a',
		'condition'		=> [ 'style'	=>	['1','2','5'] ],
	]
);

$this->end_controls_section();