<?php
/**
 * @Packge     : consua
 * @Version    : 1.0
 * @Author     : consua
 * @Author URI : https://themeforest.net/user/validthemes/portfolio
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function consua_core_essential_scripts( ) {
    wp_enqueue_script('consua-ajax',CONSUA_PLUGDIRURI.'assets/js/consua.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'consua-ajax',
    'consuaajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'consua-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','consua_core_essential_scripts');


// consua Section subscribe ajax callback function
add_action( 'wp_ajax_consua_subscribe_ajax', 'consua_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_consua_subscribe_ajax', 'consua_subscribe_ajax' );

function consua_subscribe_ajax( ){
  $apiKey = consua_opt('consua_subscribe_apikey');
  $listid = consua_opt('consua_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'consua-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'consua').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);
           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'consua').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'consua').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'consua').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'consua').'</div>';
        }
   }

   wp_die();

}